/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.http.HttpException;

final class QValueWriter
extends Writer<Object, Object> {
    final int weight;
    final int step;

    QValueWriter(int weight, int step) {
        this.weight = weight;
        this.step = step;
    }

    QValueWriter(float weight) {
        if (weight < 0.0f || weight > 1.0f) {
            throw new HttpException("invalid qvalue: " + weight);
        }
        this.weight = (int)(weight * 1000.0f);
        this.step = 1;
    }

    public Writer<Object, Object> pull(Output<?> output) {
        return QValueWriter.write(output, this.weight, this.step);
    }

    static Writer<Object, Object> write(Output<?> output, int weight, int step) {
        if (step == 1 && output.isCont()) {
            output = output.write(59);
            step = 2;
        }
        if (step == 2 && output.isCont()) {
            output = output.write(32);
            step = 3;
        }
        if (step == 3 && output.isCont()) {
            output = output.write(113);
            step = 4;
        }
        if (step == 4 && output.isCont()) {
            output = output.write(61);
            step = 5;
        }
        if (step == 5 && output.isCont()) {
            output = output.write(48 + weight / 1000);
            if ((weight %= 1000) == 0) {
                return QValueWriter.done();
            }
            step = 6;
        }
        if (step == 6 && output.isCont()) {
            output = output.write(46);
            step = 7;
        }
        if (step == 7 && output.isCont()) {
            output = output.write(48 + weight / 100);
            if ((weight %= 100) == 0) {
                return QValueWriter.done();
            }
            step = 8;
        }
        if (step == 8 && output.isCont()) {
            output = output.write(48 + weight / 10);
            if ((weight %= 10) == 0) {
                return QValueWriter.done();
            }
            step = 9;
        }
        if (step == 9 && output.isCont()) {
            output = output.write(48 + weight);
            return QValueWriter.done();
        }
        if (output.isDone()) {
            return QValueWriter.error((Throwable)new WriterException("truncated"));
        }
        if (output.isError()) {
            return QValueWriter.error((Throwable)output.trap());
        }
        return new QValueWriter(weight, step);
    }

    static Writer<Object, Object> write(Output<?> output, float weight) {
        if (weight >= 0.0f && weight <= 1.0f) {
            return QValueWriter.write(output, (int)(weight * 1000.0f), 1);
        }
        return QValueWriter.error((Throwable)new HttpException("invalid qvalue: " + weight));
    }
}

