/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Writer;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.header.HostParser;
import swim.http.header.HostWriter;
import swim.uri.UriAuthority;
import swim.uri.UriHost;
import swim.uri.UriPort;
import swim.util.Murmur3;

public final class Host
extends HttpHeader {
    final UriHost host;
    final UriPort port;
    private static int hashSeed;

    Host(UriHost host, UriPort port) {
        this.host = host;
        this.port = port;
    }

    @Override
    public String lowerCaseName() {
        return "host";
    }

    @Override
    public String name() {
        return "Host";
    }

    public UriHost getHost() {
        return this.host;
    }

    public UriPort port() {
        return this.port;
    }

    public InetSocketAddress inetSocketAddress() throws UnknownHostException {
        return new InetSocketAddress(this.host.inetAddress(), this.port.number());
    }

    @Override
    public Writer<?, ?> writeHttpValue(Output<?> output, HttpWriter http) {
        return HostWriter.write(output, this.host, this.port);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Host) {
            Host that = (Host)other;
            return this.host.equals((Object)that.host) && this.port.equals((Object)that.port);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(Host.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.host.hashCode()), (int)this.port.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("Host").write(46).write("from").write(40).debug((Object)this.host.toString());
        if (this.port.isDefined()) {
            output = output.write(", ").debug((Object)this.port.number());
        }
        output = output.write(41);
    }

    public static Host from(UriHost host, UriPort port) {
        return new Host(host, port);
    }

    public static Host from(UriHost host) {
        return new Host(host, UriPort.undefined());
    }

    public static Host from(UriAuthority authority) {
        return new Host(authority.host(), authority.port());
    }

    public static Host from(String host, int port) {
        return new Host(UriHost.parse((String)host), UriPort.from((int)port));
    }

    public static Host from(String host) {
        return new Host(UriHost.parse((String)host), UriPort.undefined());
    }

    public static Host from(InetSocketAddress address) {
        return new Host(UriHost.inetAddress((InetAddress)address.getAddress()), UriPort.from((int)address.getPort()));
    }

    public static Parser<Host> parseHttpValue(Input input, HttpParser http) {
        return HostParser.parse(input);
    }
}

