/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Base64;
import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.http.header.SecWebSocketKey;

final class SecWebSocketKeyParser
extends Parser<SecWebSocketKey> {
    final Parser<byte[]> key;

    SecWebSocketKeyParser(Parser<byte[]> key) {
        this.key = key;
    }

    SecWebSocketKeyParser() {
        this(null);
    }

    public Parser<SecWebSocketKey> feed(Input input) {
        return SecWebSocketKeyParser.parse(input, this.key);
    }

    static Parser<SecWebSocketKey> parse(Input input, Parser<byte[]> key) {
        if ((key = key == null ? Base64.standard().parseByteArray(input) : key.feed(input)).isDone()) {
            byte[] data = (byte[])key.bind();
            if (data.length != 0) {
                return SecWebSocketKeyParser.done((Object)SecWebSocketKey.from(data));
            }
            return SecWebSocketKeyParser.error((Diagnostic)Diagnostic.expected((String)"base64 digest", (Input)input));
        }
        if (key.isError()) {
            return key.asError();
        }
        if (input.isError()) {
            return SecWebSocketKeyParser.error((Throwable)input.trap());
        }
        return new SecWebSocketKeyParser((Parser<byte[]>)key);
    }

    static Parser<SecWebSocketKey> parse(Input input) {
        return SecWebSocketKeyParser.parse(input, null);
    }
}

