/*
 * Decompiled with CFR 0.152.
 */
package swim.math;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.math.PointR2Form;
import swim.math.PointZ2;
import swim.math.R2Form;
import swim.math.R2Shape;
import swim.math.R2ToZ2Function;
import swim.math.VectorR2;
import swim.structure.Kind;
import swim.structure.Value;
import swim.util.Murmur3;

public class PointR2
extends R2Shape
implements Debug {
    public final double x;
    public final double y;
    private static int hashSeed;
    private static PointR2 origin;
    private static R2Form<PointR2> form;

    public PointR2(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public final PointR2 plus(VectorR2 vector) {
        return new PointR2(this.x + vector.x, this.y + vector.y);
    }

    public final PointR2 minux(VectorR2 vector) {
        return new PointR2(this.x - vector.x, this.y - vector.y);
    }

    public final VectorR2 minus(PointR2 that) {
        return new VectorR2(this.x - that.x, this.y - that.y);
    }

    @Override
    public final double xMin() {
        return this.x;
    }

    @Override
    public final double yMin() {
        return this.y;
    }

    @Override
    public final double xMax() {
        return this.x;
    }

    @Override
    public final double yMax() {
        return this.y;
    }

    @Override
    public boolean contains(R2Shape shape) {
        return this.x <= shape.xMin() && shape.xMax() <= this.x && this.y <= shape.yMin() && shape.yMax() <= this.y;
    }

    @Override
    public boolean intersects(R2Shape shape) {
        return shape.intersects(this);
    }

    @Override
    public PointZ2 transform(R2ToZ2Function f) {
        return new PointZ2(f.transformX(this.x, this.y), f.transformY(this.x, this.y));
    }

    @Override
    public Value toValue() {
        return PointR2.form().mold(this).toValue();
    }

    protected boolean canEqual(PointR2 that) {
        return true;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof PointR2) {
            PointR2 that = (PointR2)other;
            return that.canEqual(this) && this.x == that.x && this.y == that.y;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(PointR2.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)Murmur3.hash((double)this.x)), (int)Murmur3.hash((double)this.y)));
    }

    public void debug(Output<?> output) {
        output.write("PointR2").write(46).write("of").write(40).debug((Object)this.x).write(", ").debug((Object)this.y).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static PointR2 origin() {
        if (origin == null) {
            origin = new PointR2(0.0, 0.0);
        }
        return origin;
    }

    public static PointR2 of(double x, double y) {
        return new PointR2(x, y);
    }

    @Kind
    public static R2Form<PointR2> form() {
        if (form == null) {
            form = new PointR2Form();
        }
        return form;
    }
}

