/*
 * Decompiled with CFR 0.152.
 */
package swim.math;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.math.AffineSpace;
import swim.math.F3;
import swim.math.PointR3;
import swim.math.R;
import swim.math.TensorDims;
import swim.math.VectorR3;
import swim.math.VectorSpace;

public class R3
implements AffineSpace<PointR3, VectorR3, Double>,
VectorSpace<VectorR3, Double>,
F3<VectorR3, Double>,
Debug {
    private static R3 space;

    protected R3() {
    }

    public final R3 vector() {
        return this;
    }

    @Override
    public final R scalar() {
        return R.field();
    }

    @Override
    public TensorDims dimensions() {
        return TensorDims.d3();
    }

    @Override
    public final PointR3 origin() {
        return PointR3.origin();
    }

    @Override
    public final VectorR3 zero() {
        return VectorR3.zero();
    }

    @Override
    public final VectorR3 of(Double x, Double y, Double z) {
        return VectorR3.of(x, y, z);
    }

    @Override
    public final Double getX(VectorR3 v) {
        return v.x;
    }

    @Override
    public final Double getY(VectorR3 v) {
        return v.y;
    }

    @Override
    public final Double getZ(VectorR3 v) {
        return v.z;
    }

    @Override
    public final VectorR3 add(VectorR3 u, VectorR3 v) {
        return u.plus(v);
    }

    @Override
    public final VectorR3 opposite(VectorR3 v) {
        return v.opposite();
    }

    @Override
    public final VectorR3 subtract(VectorR3 u, VectorR3 v) {
        return u.minus(v);
    }

    @Override
    public final VectorR3 multiply(VectorR3 u, Double a) {
        return u.times(a);
    }

    @Override
    public final VectorR3 combine(Double a, VectorR3 u, Double b, VectorR3 v) {
        return new VectorR3(a * u.x + b * v.x, a * u.y + b * v.y, a * u.z + b * v.z);
    }

    @Override
    public final PointR3 translate(PointR3 p, VectorR3 v) {
        return p.plus(v);
    }

    @Override
    public final VectorR3 difference(PointR3 p, PointR3 q) {
        return p.minus(q);
    }

    public void debug(Output<?> output) {
        output.write("R3").write(46).write("space").write(40).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static R3 space() {
        if (space == null) {
            space = new R3();
        }
        return space;
    }
}

