/*
 * Decompiled with CFR 0.152.
 */
package swim.protobuf;

public enum WireType {
    VARINT(0),
    FIXED64(1),
    SIZED(2),
    START_GROUP(3),
    END_GROUP(4),
    FIXED32(5),
    RESERVED6(6),
    RESERVED7(7);

    public final int code;

    private WireType(int code) {
        this.code = code;
    }

    public boolean isVarint() {
        return this.code == 0;
    }

    public boolean isFixed64() {
        return this.code == 1;
    }

    public boolean isSized() {
        return this.code == 2;
    }

    public boolean isStartGroup() {
        return this.code == 3;
    }

    public boolean isEndGroup() {
        return this.code == 4;
    }

    public boolean isFixed32() {
        return this.code == 5;
    }

    public boolean isReserved() {
        return this.code == 6 || this.code == 7;
    }

    public String toString() {
        return "WireType" + '.' + super.toString();
    }

    public static WireType apply(int code) {
        switch (code) {
            case 0: {
                return VARINT;
            }
            case 1: {
                return FIXED64;
            }
            case 2: {
                return SIZED;
            }
            case 3: {
                return START_GROUP;
            }
            case 4: {
                return END_GROUP;
            }
            case 5: {
                return FIXED32;
            }
            case 6: {
                return RESERVED6;
            }
            case 7: {
                return RESERVED7;
            }
        }
        throw new IllegalArgumentException(Integer.toString(code));
    }
}

