/*
 * Decompiled with CFR 0.152.
 */
package swim.spatial;

public final class BitInterval {
    private BitInterval() {
    }

    public static long from(int rank, long base) {
        return rank < 64 ? (1L << rank) - 1L << 64 - rank | base >>> rank : -1L;
    }

    public static long span(long x0, long x1) {
        int rank = 64 - Long.numberOfLeadingZeros(0xFFFFFFFFFFFFFFFFL & (x0 &= Long.MAX_VALUE) & (x1 &= Long.MAX_VALUE) ^ (x0 | x1));
        long mask = (1L << rank) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        long base = (x0 | x1) & mask;
        return BitInterval.from(rank, base);
    }

    public static long union(long a, long b) {
        int aRank = Long.numberOfLeadingZeros(a ^ 0xFFFFFFFFFFFFFFFFL);
        int bRank = Long.numberOfLeadingZeros(b ^ 0xFFFFFFFFFFFFFFFFL);
        long aBase = aRank < 64 ? a << aRank : 0L;
        long bBase = bRank < 64 ? b << bRank : 0L;
        long base = aBase | bBase;
        long mask = 0xFFFFFFFFFFFFFFFFL & aBase & bBase ^ base;
        int rank = Math.max(64 - Long.numberOfLeadingZeros(mask), Math.max(aRank, bRank));
        return BitInterval.from(rank, base);
    }

    public static int rank(long bitInterval) {
        return Long.numberOfLeadingZeros(bitInterval ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static long base(long bitInterval) {
        int rank = BitInterval.rank(bitInterval);
        return rank < 64 ? bitInterval << rank : 0L;
    }

    public static long mask(long bitInterval) {
        int rank = BitInterval.rank(bitInterval);
        return rank < 64 ? (1L << rank) - 1L ^ 0xFFFFFFFFFFFFFFFFL : 0L;
    }

    public static int compare(long a, long b) {
        long bNorm;
        int aRank = Long.numberOfLeadingZeros(a ^ 0xFFFFFFFFFFFFFFFFL);
        int bRank = Long.numberOfLeadingZeros(b ^ 0xFFFFFFFFFFFFFFFFL);
        long aNorm = aRank < 64 ? a << aRank : 0L;
        long l = bNorm = bRank < 64 ? b << bRank : 0L;
        if (aRank < bRank) {
            aNorm &= (1L << bRank) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        } else if (aRank > bRank) {
            bNorm &= (1L << aRank) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return aNorm < bNorm ? -1 : (aNorm > bNorm ? 1 : 0);
    }

    public static int compare(long xa, long ya, long xb, long yb) {
        int order = BitInterval.compare(xa, xb);
        if (order == 0) {
            order = BitInterval.compare(ya, yb);
        }
        return order;
    }

    public static boolean contains(long q, long a) {
        int qRank = Long.numberOfLeadingZeros(q ^ 0xFFFFFFFFFFFFFFFFL);
        int aRank = Long.numberOfLeadingZeros(a ^ 0xFFFFFFFFFFFFFFFFL);
        long qBase = qRank < 64 ? q << qRank : 0L;
        long aBase = aRank < 64 ? a << aRank : 0L;
        long qMask = qRank < 64 ? (1L << qRank) - 1L ^ 0xFFFFFFFFFFFFFFFFL : 0L;
        return aRank <= qRank && (aBase & qMask) == qBase;
    }

    public static boolean contains(long xq, long yq, long xa, long ya) {
        return BitInterval.contains(xq, xa) && BitInterval.contains(yq, ya);
    }

    public static boolean intersects(long q, long a) {
        int qRank = Long.numberOfLeadingZeros(q ^ 0xFFFFFFFFFFFFFFFFL);
        int aRank = Long.numberOfLeadingZeros(a ^ 0xFFFFFFFFFFFFFFFFL);
        long qBase = qRank < 64 ? q << qRank : 0L;
        long aBase = aRank < 64 ? a << aRank : 0L;
        long qMask = qRank < 64 ? (1L << qRank) - 1L ^ 0xFFFFFFFFFFFFFFFFL : 0L;
        long aMask = aRank < 64 ? (1L << aRank) - 1L ^ 0xFFFFFFFFFFFFFFFFL : 0L;
        return aRank <= qRank && (aBase & qMask) == qBase || qRank <= aRank && (qBase & aMask) == aBase;
    }

    public static boolean intersects(long xq, long yq, long xa, long ya) {
        return BitInterval.intersects(xq, xa) && BitInterval.intersects(yq, ya);
    }
}

