/*
 * Decompiled with CFR 0.152.
 */
package swim.streamlet;

import java.util.Iterator;
import swim.collections.HashTrieMap;
import swim.streamlet.Inlet;
import swim.streamlet.KeyEffect;
import swim.streamlet.KeyOutlet;
import swim.streamlet.MapInlet;
import swim.streamlet.MapInletMapOutlet;
import swim.streamlet.MapOutlet;
import swim.streamlet.Outlet;
import swim.util.Cursor;

public abstract class AbstractMapInletMapOutlet<KI, KO, VI, VO, I, O>
implements MapInletMapOutlet<KI, KO, VI, VO, I, O> {
    protected MapOutlet<KI, VI, ? extends I> input = null;
    protected HashTrieMap<KI, KeyEffect> outputEffects = HashTrieMap.empty();
    protected HashTrieMap<KO, KeyEffect> inputEffects = HashTrieMap.empty();
    protected HashTrieMap<KO, KeyOutlet<KO, VO>> outlets = HashTrieMap.empty();
    protected Inlet<? super O>[] outputs = null;
    protected int version = -1;

    @Override
    public abstract boolean containsKey(KO var1);

    @Override
    public abstract VO get(KO var1);

    @Override
    public abstract O get();

    @Override
    public abstract Iterator<KO> keyIterator();

    public MapOutlet<KI, VI, ? extends I> input() {
        return this.input;
    }

    @Override
    public void bindInput(Outlet<? extends I> input) {
        if (!(input instanceof MapOutlet)) {
            throw new IllegalArgumentException(input.toString());
        }
        this.bindInput((MapOutlet)input);
    }

    public void bindInput(MapOutlet<KI, VI, ? extends I> input) {
        if (this.input != null) {
            this.input.unbindOutput(this);
        }
        this.input = input;
        if (this.input != null) {
            this.input.bindOutput(this);
        }
    }

    @Override
    public void unbindInput() {
        if (this.input != null) {
            this.input.unbindOutput(this);
        }
        this.input = null;
    }

    @Override
    public void disconnectInputs() {
        MapOutlet<KI, VI, I> input;
        if (this.outputs == null && this.outlets.isEmpty() && (input = this.input) != null) {
            input.unbindOutput(this);
            this.input = null;
            input.disconnectInputs();
        }
    }

    @Override
    public Outlet<VO> outlet(KO key) {
        KeyOutlet outlet = (KeyOutlet)this.outlets.get(key);
        if (outlet == null) {
            outlet = new KeyOutlet(this, key);
            this.outlets = this.outlets.updated(key, outlet);
        }
        return outlet;
    }

    @Override
    public Iterator<Inlet<? super O>> outputIterator() {
        return this.outputs != null ? Cursor.array((Object[])this.outputs) : Cursor.empty();
    }

    @Override
    public void bindOutput(Inlet<? super O> output) {
        Inlet<? super O>[] oldOutputs = this.outputs;
        int n = oldOutputs != null ? oldOutputs.length : 0;
        Inlet[] newOutputs = new Inlet[n + 1];
        if (n > 0) {
            System.arraycopy(oldOutputs, 0, newOutputs, 0, n);
        }
        newOutputs[n] = output;
        this.outputs = newOutputs;
    }

    @Override
    public void unbindOutput(Inlet<? super O> output) {
        Inlet<? super O>[] oldOutputs = this.outputs;
        int n = oldOutputs != null ? oldOutputs.length : 0;
        for (int i = 0; i < n; ++i) {
            if (oldOutputs[i] != output) continue;
            if (n > 1) {
                Inlet[] newOutputs = new Inlet[n - 1];
                System.arraycopy(oldOutputs, 0, newOutputs, 0, i);
                System.arraycopy(oldOutputs, i + 1, newOutputs, i, n - 1 - i);
                this.outputs = newOutputs;
                break;
            }
            this.outputs = null;
            break;
        }
    }

    @Override
    public void unbindOutputs() {
        Inlet<? super O>[] outputs;
        HashTrieMap<KO, KeyOutlet<KO, VO>> outlets = this.outlets;
        if (!outlets.isEmpty()) {
            this.outlets = HashTrieMap.empty();
            Iterator keyOutlets = outlets.valueIterator();
            while (keyOutlets.hasNext()) {
                KeyOutlet keyOutlet = (KeyOutlet)keyOutlets.next();
                keyOutlet.unbindOutputs();
            }
        }
        if ((outputs = this.outputs) != null) {
            this.outputs = null;
            for (Inlet<O> inlet : outputs) {
                inlet.unbindInput();
            }
        }
    }

    @Override
    public void disconnectOutputs() {
        if (this.input == null) {
            Inlet<? super O>[] outputs;
            HashTrieMap<KO, KeyOutlet<KO, VO>> outlets = this.outlets;
            if (!outlets.isEmpty()) {
                this.outlets = HashTrieMap.empty();
                Iterator keyOutlets = outlets.valueIterator();
                while (keyOutlets.hasNext()) {
                    KeyOutlet keyOutlet = (KeyOutlet)keyOutlets.next();
                    keyOutlet.disconnectOutputs();
                }
            }
            if ((outputs = this.outputs) != null) {
                this.outputs = null;
                for (Inlet<O> inlet : outputs) {
                    inlet.unbindInput();
                    inlet.disconnectOutputs();
                }
            }
        }
    }

    @Override
    public void invalidateOutputKey(KI key, KeyEffect effect) {
        HashTrieMap<KI, KeyEffect> oldOutputEffects = this.outputEffects;
        if (oldOutputEffects.get(key) != effect) {
            this.willInvalidateOutputKey(key, effect);
            this.outputEffects = oldOutputEffects.updated(key, (Object)effect);
            this.version = -1;
            this.onInvalidateOutputKey(key, effect);
            this.didInvalidateOutputKey(key, effect);
        }
    }

    @Override
    public void invalidateInputKey(KO key, KeyEffect effect) {
        HashTrieMap<KO, KeyEffect> oldInputEffects = this.inputEffects;
        if (oldInputEffects.get(key) != effect) {
            this.willInvalidateInputKey(key, effect);
            this.inputEffects = oldInputEffects.updated(key, (Object)effect);
            this.version = -1;
            this.onInvalidateInputKey(key, effect);
            int n = this.outputs != null ? this.outputs.length : 0;
            for (int i = 0; i < n; ++i) {
                Inlet<O> output = this.outputs[i];
                if (output instanceof MapInlet) {
                    ((MapInlet)output).invalidateOutputKey(key, effect);
                    continue;
                }
                output.invalidateOutput();
            }
            KeyOutlet outlet = (KeyOutlet)this.outlets.get(key);
            if (outlet != null) {
                outlet.invalidateInput();
            }
            this.didInvalidateInputKey(key, effect);
        }
    }

    @Override
    public void invalidateOutput() {
        this.invalidate();
    }

    @Override
    public void invalidateInput() {
        this.invalidate();
    }

    public void invalidate() {
        if (this.version >= 0) {
            this.willInvalidate();
            this.version = -1;
            this.onInvalidate();
            int n = this.outputs != null ? this.outputs.length : 0;
            for (int i = 0; i < n; ++i) {
                this.outputs[i].invalidateOutput();
            }
            Iterator outlets = this.outlets.valueIterator();
            while (outlets.hasNext()) {
                ((KeyOutlet)outlets.next()).invalidateInput();
            }
            this.didInvalidate();
        }
    }

    @Override
    public void reconcileOutputKey(KI key, int version) {
        HashTrieMap<KI, KeyEffect> oldOutputEffects;
        KeyEffect effect;
        if (this.version < 0 && (effect = (KeyEffect)((Object)(oldOutputEffects = this.outputEffects).get(key))) != null) {
            this.willReconcileOutputKey(key, effect, version);
            this.outputEffects = oldOutputEffects.removed(key);
            if (this.input != null) {
                this.input.reconcileInputKey(key, version);
            }
            this.onReconcileOutputKey(key, effect, version);
            this.didReconcileOutputKey(key, effect, version);
        }
    }

    @Override
    public void reconcileInputKey(KO key, int version) {
        HashTrieMap<KO, KeyEffect> oldInputEffects;
        KeyEffect oldEffect;
        if (this.version < 0 && (oldEffect = (KeyEffect)((Object)(oldInputEffects = this.inputEffects).get(key))) != null) {
            int n;
            KeyEffect newEffect = this.willReconcileInputKey(key, oldEffect, version);
            if (oldEffect != newEffect) {
                this.invalidateInputKey(key, newEffect);
            }
            this.inputEffects = oldInputEffects.removed(key);
            this.onReconcileInputKey(key, newEffect, version);
            int n2 = n = this.outputs != null ? this.outputs.length : 0;
            for (int i = 0; i < n; ++i) {
                Inlet<O> output = this.outputs[i];
                if (!(output instanceof MapInlet)) continue;
                ((MapInlet)output).reconcileOutputKey(key, version);
            }
            KeyOutlet outlet = (KeyOutlet)this.outlets.get(key);
            if (outlet != null) {
                outlet.reconcileInput(version);
            }
            this.didReconcileInputKey(key, newEffect, version);
        }
    }

    @Override
    public void reconcileOutput(int version) {
        this.reconcile(version);
    }

    @Override
    public void reconcileInput(int version) {
        this.reconcile(version);
    }

    public void reconcile(int version) {
        if (this.version < 0) {
            int n;
            this.willReconcile(version);
            Iterator outputKeys = this.outputEffects.keyIterator();
            while (outputKeys.hasNext()) {
                this.reconcileOutputKey((KI)outputKeys.next(), version);
            }
            Iterator inputKeys = this.inputEffects.keyIterator();
            while (inputKeys.hasNext()) {
                this.reconcileInputKey((KO)inputKeys.next(), version);
            }
            this.version = version;
            this.onReconcile(version);
            int n2 = n = this.outputs != null ? this.outputs.length : 0;
            for (int i = 0; i < n; ++i) {
                this.outputs[i].reconcileOutput(version);
            }
            this.didReconcile(version);
        }
    }

    protected void willInvalidateOutputKey(KI key, KeyEffect effect) {
    }

    protected void onInvalidateOutputKey(KI key, KeyEffect effect) {
    }

    protected void didInvalidateOutputKey(KI key, KeyEffect effect) {
    }

    protected void willInvalidateInputKey(KO key, KeyEffect effect) {
    }

    protected void onInvalidateInputKey(KO key, KeyEffect effect) {
    }

    protected void didInvalidateInputKey(KO key, KeyEffect effect) {
    }

    protected void willInvalidate() {
    }

    protected void onInvalidate() {
    }

    protected void didInvalidate() {
    }

    protected void willReconcileOutputKey(KI key, KeyEffect effect, int version) {
    }

    protected void onReconcileOutputKey(KI key, KeyEffect effect, int version) {
    }

    protected void didReconcileOutputKey(KI key, KeyEffect effect, int version) {
    }

    protected KeyEffect willReconcileInputKey(KO key, KeyEffect effect, int version) {
        return effect;
    }

    protected void onReconcileInputKey(KO key, KeyEffect effect, int version) {
    }

    protected void didReconcileInputKey(KO key, KeyEffect effect, int version) {
    }

    protected void willReconcile(int version) {
    }

    protected void onReconcile(int version) {
    }

    protected void didReconcile(int version) {
    }
}

