/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import swim.collections.HashTrieMap;
import swim.uri.Uri;
import swim.uri.UriAuthority;
import swim.uri.UriAuthorityPattern;
import swim.uri.UriFragment;
import swim.uri.UriPath;
import swim.uri.UriPathPattern;
import swim.uri.UriQuery;
import swim.uri.UriScheme;

final class UriAuthorityLiteral
extends UriAuthorityPattern {
    final UriAuthority authority;
    final UriPathPattern rest;

    UriAuthorityLiteral(UriAuthority authority, UriPathPattern rest) {
        this.authority = authority;
        this.rest = rest;
    }

    @Override
    public Uri toUri() {
        return this.rest.toUri();
    }

    @Override
    Uri apply(UriScheme scheme, String[] args, int index) {
        return this.rest.apply(scheme, this.authority, args, index);
    }

    @Override
    HashTrieMap<String, String> unapply(UriAuthority authority, UriPath path, UriQuery query, UriFragment fragment, HashTrieMap<String, String> args) {
        if (this.authority.equals(authority)) {
            return this.rest.unapply(path, query, fragment, args);
        }
        return args;
    }

    @Override
    boolean matches(UriAuthority authority, UriPath path, UriQuery query, UriFragment fragment) {
        if (this.authority.equals(authority)) {
            return this.rest.matches(path, query, fragment);
        }
        return false;
    }
}

