/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import swim.codec.Debug;
import swim.codec.Display;
import swim.codec.Format;
import swim.codec.Output;
import swim.uri.Uri;
import swim.util.HashGenCacheMap;

public class UriFragment
implements Comparable<UriFragment>,
Debug,
Display {
    protected final String identifier;
    String string;
    private static UriFragment undefined;
    private static HashGenCacheMap<String, UriFragment> cache;

    protected UriFragment(String identifier) {
        this.identifier = identifier;
    }

    public final boolean isDefined() {
        return this.identifier != null;
    }

    public String identifier() {
        return this.identifier;
    }

    @Override
    public final int compareTo(UriFragment that) {
        return this.toString().compareTo(that.toString());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof UriFragment) {
            UriFragment that = (UriFragment)other;
            return this.identifier == null ? that.identifier == null : this.identifier.equals(that.identifier);
        }
        return false;
    }

    public int hashCode() {
        return this.identifier == null ? 0 : this.identifier.hashCode();
    }

    public void debug(Output<?> output) {
        output = output.write("UriFragment").write(46);
        output = this.isDefined() ? output.write("parse").write(40).write(34).display((Object)this).write(34).write(41) : output.write("undefined").write(40).write(41);
    }

    public void display(Output<?> output) {
        if (this.string != null) {
            output = output.write(this.string);
        } else if (this.identifier != null) {
            Uri.writeFragment(this.identifier, output);
        }
    }

    public String toString() {
        if (this.string == null) {
            this.string = Format.display((Object)this);
        }
        return this.string;
    }

    public static UriFragment undefined() {
        if (undefined == null) {
            undefined = new UriFragment(null);
        }
        return undefined;
    }

    public static UriFragment from(String identifier) {
        if (identifier != null) {
            HashGenCacheMap<String, UriFragment> cache = UriFragment.cache();
            UriFragment fragment = (UriFragment)cache.get((Object)identifier);
            if (fragment != null) {
                return fragment;
            }
            return (UriFragment)cache.put((Object)identifier, (Object)new UriFragment(identifier));
        }
        return UriFragment.undefined();
    }

    public static UriFragment parse(String string) {
        return Uri.standardParser().parseFragmentString(string);
    }

    static HashGenCacheMap<String, UriFragment> cache() {
        if (cache == null) {
            int cacheSize;
            try {
                cacheSize = Integer.parseInt(System.getProperty("swim.uri.fragment.cache.size"));
            }
            catch (NumberFormatException e) {
                cacheSize = 32;
            }
            cache = new HashGenCacheMap(cacheSize);
        }
        return cache;
    }
}

