/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import swim.collections.HashTrieMap;
import swim.uri.Uri;
import swim.uri.UriAuthority;
import swim.uri.UriFragment;
import swim.uri.UriPath;
import swim.uri.UriPathBuilder;
import swim.uri.UriPathPattern;
import swim.uri.UriQuery;
import swim.uri.UriScheme;

final class UriPathLiteral
extends UriPathPattern {
    final String component;
    final UriPathPattern rest;

    UriPathLiteral(String component, UriPathPattern rest) {
        this.component = component;
        this.rest = rest;
    }

    @Override
    public Uri toUri() {
        return this.rest.toUri();
    }

    @Override
    Uri apply(UriScheme scheme, UriAuthority authority, UriPathBuilder path, String[] args, int index) {
        path.add(this.component);
        return this.rest.apply(scheme, authority, path, args, index);
    }

    @Override
    HashTrieMap<String, String> unapply(UriPath path, UriQuery query, UriFragment fragment, HashTrieMap<String, String> args) {
        if (!path.isEmpty() && this.component.equals(path.head())) {
            return this.rest.unapply(path.tail(), query, fragment, args);
        }
        return args;
    }

    @Override
    boolean matches(UriPath path, UriQuery query, UriFragment fragment) {
        if (!path.isEmpty() && this.component.equals(path.head())) {
            return this.rest.matches(path.tail(), query, fragment);
        }
        return false;
    }
}

