/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import swim.collections.HashTrieMap;
import swim.uri.Uri;
import swim.uri.UriAuthority;
import swim.uri.UriFragment;
import swim.uri.UriFragmentPattern;
import swim.uri.UriPath;
import swim.uri.UriQuery;
import swim.uri.UriQueryPattern;
import swim.uri.UriScheme;

final class UriQueryLiteral
extends UriQueryPattern {
    final UriQuery query;
    final UriFragmentPattern rest;

    UriQueryLiteral(UriQuery query, UriFragmentPattern rest) {
        this.query = query;
        this.rest = rest;
    }

    @Override
    public Uri toUri() {
        return this.rest.toUri();
    }

    @Override
    Uri apply(UriScheme scheme, UriAuthority authority, UriPath path, String[] args, int index) {
        return this.rest.apply(scheme, authority, path, this.query, args, index);
    }

    @Override
    HashTrieMap<String, String> unapply(UriQuery query, UriFragment fragment, HashTrieMap<String, String> args) {
        return this.rest.unapply(fragment, args);
    }

    @Override
    boolean matches(UriQuery query, UriFragment fragment) {
        if (this.query.equals(query)) {
            return this.rest.matches(fragment);
        }
        return false;
    }
}

