/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import swim.codec.Debug;
import swim.codec.Display;
import swim.codec.Format;
import swim.codec.Output;
import swim.uri.Uri;
import swim.util.Murmur3;

public class UriUser
implements Debug,
Display {
    protected final String username;
    protected final String password;
    private static int hashSeed;
    private static UriUser undefined;

    protected UriUser(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public boolean isDefined() {
        return this.username != null;
    }

    public String username() {
        return this.username != null ? this.username : "";
    }

    public UriUser username(String username) {
        if (username != this.username) {
            return this.copy(username, this.password);
        }
        return this;
    }

    public String password() {
        return this.password != null ? this.password : "";
    }

    public UriUser password(String password) {
        if (password != this.password) {
            return this.copy(this.username, password);
        }
        return this;
    }

    protected UriUser copy(String username, String password) {
        return UriUser.from(username, password);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof UriUser) {
            UriUser that = (UriUser)other;
            return (this.username == null ? that.username == null : this.username.equals(that.username)) && (this.password == null ? that.password == null : this.password.equals(that.password));
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(UriUser.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)Murmur3.hash((Object)this.username)), (int)Murmur3.hash((Object)this.password)));
    }

    public void debug(Output<?> output) {
        output = output.write("UriUser").write(46);
        output = this.isDefined() ? output.write("parse").write(40).write(34).display((Object)this).write(34).write(41) : output.write("undefined").write(40).write(41);
    }

    public void display(Output<?> output) {
        if (this.username != null) {
            Uri.writeUser(this.username, output);
            if (this.password != null) {
                output = output.write(58);
                Uri.writeUser(this.password, output);
            }
        }
    }

    public String toString() {
        return Format.display((Object)this);
    }

    public static UriUser undefined() {
        if (undefined == null) {
            undefined = new UriUser(null, null);
        }
        return undefined;
    }

    public static UriUser from(String username) {
        if (username != null) {
            return new UriUser(username, null);
        }
        return UriUser.undefined();
    }

    public static UriUser from(String username, String password) {
        if (username != null || password != null) {
            if (username == null) {
                username = "";
            }
            return new UriUser(username, password);
        }
        return UriUser.undefined();
    }

    public static UriUser parse(String string) {
        return Uri.standardParser().parseUserString(string);
    }
}

