/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import java.nio.ByteBuffer;
import swim.codec.InputBuffer;
import swim.codec.InputException;
import swim.codec.InputSettings;
import swim.codec.Mark;

final class ByteBufferInput
extends InputBuffer {
    ByteBuffer buffer;
    Object id;
    long offset;
    InputSettings settings;
    boolean isPart;

    ByteBufferInput(ByteBuffer buffer, Object id, long offset, InputSettings settings, boolean isPart) {
        this.buffer = buffer;
        this.id = id;
        this.offset = offset;
        this.settings = settings;
        this.isPart = isPart;
    }

    ByteBufferInput(ByteBuffer buffer) {
        this(buffer, null, 0L, InputSettings.standard(), false);
    }

    @Override
    public boolean isCont() {
        return this.buffer.hasRemaining();
    }

    @Override
    public boolean isEmpty() {
        return this.isPart && !this.buffer.hasRemaining();
    }

    @Override
    public boolean isDone() {
        return !this.isPart && !this.buffer.hasRemaining();
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public boolean isPart() {
        return this.isPart;
    }

    @Override
    public InputBuffer isPart(boolean isPart) {
        this.isPart = isPart;
        return this;
    }

    @Override
    public int index() {
        return this.buffer.position();
    }

    @Override
    public InputBuffer index(int index) {
        this.buffer.position(index);
        return this;
    }

    @Override
    public int limit() {
        return this.buffer.limit();
    }

    @Override
    public InputBuffer limit(int limit) {
        this.buffer.limit(limit);
        return this;
    }

    @Override
    public int capacity() {
        return this.buffer.capacity();
    }

    @Override
    public int remaining() {
        return this.buffer.remaining();
    }

    @Override
    public byte[] array() {
        return this.buffer.array();
    }

    @Override
    public int arrayOffset() {
        return this.buffer.arrayOffset();
    }

    @Override
    public boolean has(int index) {
        return 0 <= index && index < this.buffer.limit();
    }

    @Override
    public int get(int index) {
        if (0 <= index && index < this.buffer.limit()) {
            return this.buffer.get(index) & 0xFF;
        }
        throw new InputException();
    }

    @Override
    public void set(int index, int token) {
        if (0 > index || index >= this.buffer.limit()) {
            throw new InputException();
        }
        this.buffer.put(index, (byte)token);
    }

    @Override
    public int head() {
        ByteBuffer buffer = this.buffer;
        int position = buffer.position();
        if (position < buffer.limit()) {
            return buffer.get(position) & 0xFF;
        }
        throw new InputException();
    }

    @Override
    public InputBuffer step() {
        ByteBuffer buffer = this.buffer;
        int position = buffer.position();
        if (position < buffer.limit()) {
            buffer.position(position + 1);
            ++this.offset;
            return this;
        }
        InputException error = new InputException("invalid step");
        return InputBuffer.error(error, this.id, this.mark(), this.settings);
    }

    @Override
    public InputBuffer step(int offset) {
        ByteBuffer buffer = this.buffer;
        int position = buffer.position() + offset;
        if (0 <= position && position <= buffer.limit()) {
            buffer.position(position);
            this.offset += (long)offset;
            return this;
        }
        InputException error = new InputException("invalid step");
        return InputBuffer.error(error, this.id, this.mark(), this.settings);
    }

    @Override
    public InputBuffer seek(Mark mark) {
        ByteBuffer buffer = this.buffer;
        if (mark != null) {
            long position = (long)buffer.position() + (this.offset - mark.offset);
            if (0L <= position && position <= (long)buffer.limit()) {
                buffer.position((int)position);
                this.offset = mark.offset;
                return this;
            }
            InputException error = new InputException("invalid seek to " + mark);
            return InputBuffer.error(error, this.id, this.mark(), this.settings);
        }
        this.offset -= (long)buffer.position();
        buffer.position(0);
        return this;
    }

    @Override
    public Object id() {
        return this.id;
    }

    @Override
    public InputBuffer id(Object id) {
        this.id = id;
        return this;
    }

    @Override
    public Mark mark() {
        return Mark.at(this.offset, 0, 0);
    }

    @Override
    public InputBuffer mark(Mark mark) {
        this.offset = mark.offset;
        return this;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public int line() {
        return 0;
    }

    @Override
    public int column() {
        return 0;
    }

    @Override
    public InputSettings settings() {
        return this.settings;
    }

    @Override
    public InputBuffer settings(InputSettings settings) {
        this.settings = settings;
        return this;
    }

    @Override
    public InputBuffer clone() {
        return new ByteBufferInput(this.buffer.duplicate(), this.id, this.offset, this.settings, this.isPart);
    }
}

