/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.Input;
import swim.codec.Parser;

final class InputParser<O>
extends Parser<O> {
    final Input input;
    final Parser<O> parser;

    InputParser(Input input, Parser<O> parser) {
        this.input = input;
        this.parser = parser;
    }

    @Override
    public Parser<O> feed(Input input) {
        if (this.input != null) {
            input = this.input.fork(input);
        }
        return InputParser.parse(input, this.parser);
    }

    @Override
    public Parser<O> fork(Object condition) {
        return new InputParser<O>(this.input, this.parser.fork(condition));
    }

    @Override
    public O bind() {
        return this.parser.bind();
    }

    @Override
    public Throwable trap() {
        return this.parser.trap();
    }

    static <O> Parser<O> parse(Input input, Parser<O> parser) {
        if (!(parser = parser.feed(input)).isCont()) {
            return parser;
        }
        if (input.isError()) {
            return InputParser.error(input.trap());
        }
        return new InputParser<O>(input, parser);
    }
}

