/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.Output;
import swim.codec.OutputException;
import swim.codec.OutputSettings;

final class OutputDone<T>
extends Output<T> {
    final T value;
    final OutputSettings settings;

    OutputDone(T value, OutputSettings settings) {
        this.value = value;
        this.settings = settings;
    }

    @Override
    public boolean isCont() {
        return false;
    }

    @Override
    public boolean isFull() {
        return false;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public boolean isPart() {
        return false;
    }

    @Override
    public Output<T> isPart(boolean isPart) {
        if (isPart) {
            return this;
        }
        return Output.full(this.value, this.settings);
    }

    @Override
    public Output<T> write(int token) {
        return Output.error(new OutputException("done"), this.settings);
    }

    @Override
    public Output<T> write(String string) {
        return Output.error(new OutputException("done"), this.settings);
    }

    @Override
    public Output<T> writeln(String string) {
        return Output.error(new OutputException("done"), this.settings);
    }

    @Override
    public Output<T> writeln() {
        return Output.error(new OutputException("done"), this.settings);
    }

    @Override
    public T bind() {
        return this.value;
    }

    @Override
    public OutputSettings settings() {
        return this.settings;
    }

    @Override
    public Output<T> settings(OutputSettings settings) {
        return Output.done(this.value, settings);
    }

    @Override
    public Output<T> clone() {
        return this;
    }
}

