/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.Output;
import swim.codec.Writer;

final class OutputWriter<I, O>
extends Writer<I, O> {
    final Output<?> output;
    final Writer<I, O> writer;

    OutputWriter(Output<?> output, Writer<I, O> writer) {
        this.output = output;
        this.writer = writer;
    }

    @Override
    public Writer<I, O> feed(I input) {
        return new OutputWriter<I, O>(this.output, this.writer.feed((Object)input));
    }

    @Override
    public Writer<I, O> pull(Output<?> output) {
        if (this.output != null) {
            output = this.output.fork(output);
        }
        return OutputWriter.write(output, this.writer);
    }

    @Override
    public Writer<I, O> fork(Object condition) {
        return new OutputWriter<I, O>(this.output, this.writer.fork(condition));
    }

    @Override
    public O bind() {
        return this.writer.bind();
    }

    @Override
    public Throwable trap() {
        return this.writer.trap();
    }

    static <I, O> Writer<I, O> write(Output<?> output, Writer<I, O> writer) {
        if (!(writer = writer.pull(output)).isCont()) {
            return writer;
        }
        return new OutputWriter<I, O>(output, writer);
    }
}

