/*
 * Decompiled with CFR 0.152.
 */
package swim.recon;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.recon.Recon;
import swim.recon.ReconParser;
import swim.util.Builder;

final class BlockParser<I, V>
extends Parser<V> {
    final ReconParser<I, V> recon;
    final Builder<I, V> builder;
    final Parser<V> keyParser;
    final Parser<V> valueParser;
    final int step;

    BlockParser(ReconParser<I, V> recon, Builder<I, V> builder, Parser<V> keyParser, Parser<V> valueParser, int step) {
        this.recon = recon;
        this.builder = builder;
        this.keyParser = keyParser;
        this.valueParser = valueParser;
        this.step = step;
    }

    BlockParser(ReconParser<I, V> recon) {
        this(recon, null, null, null, 1);
    }

    public Parser<V> feed(Input input) {
        return BlockParser.parse(input, this.recon, this.builder, this.keyParser, this.valueParser, this.step);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static <I, V> Parser<V> parse(Input input, ReconParser<I, V> recon, Builder<I, V> builder, Parser<V> keyParser, Parser<V> valueParser, int step) {
        int c = 0;
        block0: while (true) {
            if (step == 1) {
                while (input.isCont() && Recon.isWhitespace(c = input.head())) {
                    input = input.step();
                }
                if (input.isCont()) {
                    if (c == 33 || c == 34 || c == 36 || c == 37 || c == 39 || c == 40 || c == 43 || c == 45 || c >= 48 && c <= 57 || c == 64 || c == 91 || c == 123 || c == 126 || Recon.isIdentStartChar(c)) {
                        if (builder == null) {
                            builder = recon.valueBuilder();
                        }
                        step = 2;
                    } else {
                        if (c != 35) return BlockParser.error((Diagnostic)Diagnostic.expected((String)"block", (Input)input));
                        input = input.step();
                        step = 7;
                    }
                } else {
                    if (input.isError()) {
                        return BlockParser.error((Throwable)input.trap());
                    }
                    if (input.isDone()) {
                        if (builder == null) return BlockParser.done((Object)recon.absent());
                        return BlockParser.done((Object)builder.bind());
                    }
                }
            }
            if (step == 2) {
                if (keyParser == null) {
                    keyParser = recon.parseBlockExpression(input);
                }
                while (keyParser.isCont() && !input.isEmpty()) {
                    keyParser = keyParser.feed(input);
                }
                if (keyParser.isDone()) {
                    step = 3;
                } else if (keyParser.isError()) {
                    return keyParser;
                }
            }
            if (step == 3) {
                while (input.isCont() && Recon.isSpace(c = input.head())) {
                    input = input.step();
                }
                if (input.isCont()) {
                    if (c == 58) {
                        input = input.step();
                        step = 4;
                    } else {
                        builder.add(recon.item(keyParser.bind()));
                        keyParser = null;
                        step = 6;
                    }
                } else if (input.isDone()) {
                    builder.add(recon.item(keyParser.bind()));
                    return BlockParser.done((Object)builder.bind());
                }
            }
            if (step == 4) {
                while (input.isCont() && Recon.isSpace(input.head())) {
                    input = input.step();
                }
                if (input.isCont()) {
                    step = 5;
                } else if (input.isDone()) {
                    builder.add(recon.slot(keyParser.bind()));
                    return BlockParser.done((Object)builder.bind());
                }
            }
            if (step == 5) {
                if (valueParser == null) {
                    valueParser = recon.parseBlockExpression(input);
                }
                while (valueParser.isCont() && !input.isEmpty()) {
                    valueParser = valueParser.feed(input);
                }
                if (valueParser.isDone()) {
                    builder.add(recon.slot(keyParser.bind(), valueParser.bind()));
                    keyParser = null;
                    valueParser = null;
                    step = 6;
                } else if (valueParser.isError()) {
                    return valueParser;
                }
            }
            if (step == 6) {
                while (input.isCont() && Recon.isSpace(c = input.head())) {
                    input = input.step();
                }
                if (input.isCont()) {
                    if (c == 44 || c == 59 || Recon.isNewline(c)) {
                        input = input.step();
                        step = 1;
                        continue;
                    }
                    if (c != 35) return BlockParser.done((Object)builder.bind());
                    input = input.step();
                    step = 7;
                } else if (input.isDone()) {
                    return BlockParser.done((Object)builder.bind());
                }
            }
            if (step != 7) break;
            while (input.isCont()) {
                c = input.head();
                if (!Recon.isNewline(c)) {
                    input = input.step();
                    continue;
                }
                step = 1;
                continue block0;
            }
            if (!input.isDone()) break;
            step = 1;
        }
        if (!input.isError()) return new BlockParser<I, Object>(recon, builder, (Parser<Object>)keyParser, (Parser<Object>)valueParser, step);
        return BlockParser.error((Throwable)input.trap());
    }

    static <I, V> Parser<V> parse(Input input, ReconParser<I, V> recon) {
        return BlockParser.parse(input, recon, null, null, null, 1);
    }
}

