/*
 * Decompiled with CFR 0.152.
 */
package swim.util;

import java.util.NoSuchElementException;
import swim.util.Cursor;

final class CursorArray<T>
implements Cursor<T> {
    final Object[] array;
    int index;
    int limit;

    CursorArray(Object[] array, int index, int limit) {
        this.array = array;
        this.index = index;
        this.limit = limit;
    }

    @Override
    public boolean isEmpty() {
        return this.index >= this.limit;
    }

    @Override
    public T head() {
        if (this.index < this.limit) {
            return (T)this.array[this.index];
        }
        throw new NoSuchElementException();
    }

    @Override
    public void step() {
        if (this.index >= this.limit) {
            throw new UnsupportedOperationException();
        }
        this.index = 1;
    }

    @Override
    public void skip(long count) {
        this.index = (int)Math.max(0L, Math.min((long)this.index + count, (long)this.limit));
    }

    @Override
    public boolean hasNext() {
        return this.index < this.limit;
    }

    @Override
    public long nextIndexLong() {
        return this.index;
    }

    @Override
    public int nextIndex() {
        return this.index;
    }

    @Override
    public T next() {
        int index = this.index;
        if (index < this.limit) {
            this.index = index + 1;
            return (T)this.array[index];
        }
        this.index = this.limit;
        throw new NoSuchElementException();
    }

    @Override
    public boolean hasPrevious() {
        return this.index > 0;
    }

    @Override
    public long previousIndexLong() {
        return this.index - 1;
    }

    @Override
    public int previousIndex() {
        return this.index - 1;
    }

    @Override
    public T previous() {
        int index = this.index - 1;
        if (index >= 0) {
            this.index = index;
            return (T)this.array[index];
        }
        this.index = 0;
        throw new NoSuchElementException();
    }
}

