/*
 * Decompiled with CFR 0.152.
 */
package swim.ws;

import swim.codec.Binary;
import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.InputBuffer;
import swim.codec.Output;
import swim.structure.Data;
import swim.ws.WsClose;
import swim.ws.WsFragment;
import swim.ws.WsFrame;
import swim.ws.WsFrameDecoder;
import swim.ws.WsOpcode;
import swim.ws.WsOpcodeDecoder;
import swim.ws.WsPing;
import swim.ws.WsPong;
import swim.ws.WsStatus;
import swim.ws.WsValue;

public abstract class WsDecoder {
    public <T> WsFrame<T> fragment(WsOpcode opcode, Decoder<T> content) {
        return new WsFragment<T>(opcode, content);
    }

    public <T> WsFrame<T> message(T value) {
        return new WsValue<T>(value);
    }

    public <P, T> WsFrame<T> control(WsOpcode opcode, P payload) {
        switch (opcode) {
            case CLOSE: {
                return this.close(payload);
            }
            case PING: {
                return this.ping(payload);
            }
            case PONG: {
                return this.pong(payload);
            }
        }
        throw new IllegalArgumentException(opcode.toString());
    }

    public <P, T> WsFrame<T> close(P payload) {
        return WsClose.from(payload);
    }

    public <P, T> WsFrame<T> ping(P payload) {
        return WsPing.from(payload);
    }

    public <P, T> WsFrame<T> pong(P payload) {
        return WsPong.from(payload);
    }

    public <T> Decoder<T> continuationDecoder(Decoder<T> content) {
        return content;
    }

    public <T> Decoder<T> textDecoder(Decoder<T> content) {
        return content.fork((Object)WsOpcode.TEXT);
    }

    public <T> Decoder<T> binaryDecoder(Decoder<T> content) {
        return content.fork((Object)WsOpcode.BINARY);
    }

    public <T> Decoder<?> closeDecoder(Decoder<T> content) {
        return WsStatus.decoder();
    }

    public <T> Decoder<?> pingDecoder(Decoder<T> content) {
        return Binary.outputParser((Output)Data.output());
    }

    public <T> Decoder<?> pongDecoder(Decoder<T> content) {
        return Binary.outputParser((Output)Data.output());
    }

    public <T> Decoder<WsFrame<T>> frameDecoder(Decoder<T> content) {
        return new WsOpcodeDecoder<T>(this, content);
    }

    public <T> Decoder<WsFrame<T>> decodeFrame(Decoder<T> content, InputBuffer input) {
        return WsOpcodeDecoder.decode(input, this, content);
    }

    public <T> Decoder<WsFrame<T>> decodeFrame(int finRsvOp, Decoder<T> content, InputBuffer input) {
        int opcode = finRsvOp & 0xF;
        switch (opcode) {
            case 0: {
                return this.decodeContinuationFrame(finRsvOp, this.continuationDecoder(content), input);
            }
            case 1: {
                return this.decodeTextFrame(finRsvOp, this.textDecoder(content), input);
            }
            case 2: {
                return this.decodeBinaryFrame(finRsvOp, this.binaryDecoder(content), input);
            }
            case 8: {
                return this.decodeCloseFrame(finRsvOp, this.closeDecoder(content), input);
            }
            case 9: {
                return this.decodePingFrame(finRsvOp, this.pingDecoder(content), input);
            }
            case 10: {
                return this.decodePongFrame(finRsvOp, this.pongDecoder(content), input);
            }
        }
        return Decoder.error((Throwable)new DecoderException("reserved opcode: " + WsOpcode.from(opcode)));
    }

    public <T> Decoder<WsFrame<T>> decodeContinuationFrame(int finRsvOp, Decoder<T> content, InputBuffer input) {
        return WsFrameDecoder.decode(input, this, content);
    }

    public <T> Decoder<WsFrame<T>> decodeTextFrame(int finRsvOp, Decoder<T> content, InputBuffer input) {
        return WsFrameDecoder.decode(input, this, content);
    }

    public <T> Decoder<WsFrame<T>> decodeBinaryFrame(int finRsvOp, Decoder<T> content, InputBuffer input) {
        return WsFrameDecoder.decode(input, this, content);
    }

    public <P, T> Decoder<WsFrame<T>> decodeCloseFrame(int finRsvOp, Decoder<P> content, InputBuffer input) {
        return WsFrameDecoder.decode(input, this, content);
    }

    public <P, T> Decoder<WsFrame<T>> decodePingFrame(int finRsvOp, Decoder<P> content, InputBuffer input) {
        return WsFrameDecoder.decode(input, this, content);
    }

    public <P, T> Decoder<WsFrame<T>> decodePongFrame(int finRsvOp, Decoder<P> content, InputBuffer input) {
        return WsFrameDecoder.decode(input, this, content);
    }
}

