/*
 * Decompiled with CFR 0.152.
 */
package swim.ws;

import swim.deflate.Deflate;
import swim.deflate.Inflate;
import swim.http.WebSocketExtension;
import swim.http.WebSocketParam;
import swim.ws.Ws;
import swim.ws.WsDecoder;
import swim.ws.WsEncoder;
import swim.ws.WsEngine;
import swim.ws.WsEngineSettings;
import swim.ws.WsException;

final class WsDeflateClientEngine
extends WsEngine {
    protected final int clientCompressionLevel;
    protected final boolean clientNoContextTakeover;
    protected final int serverMaxWindowBits;
    protected final int clientMaxWindowBits;

    WsDeflateClientEngine(int clientCompressionLevel, boolean clientNoContextTakeover, int serverMaxWindowBits, int clientMaxWindowBits) {
        this.clientCompressionLevel = clientCompressionLevel;
        this.clientNoContextTakeover = clientNoContextTakeover;
        this.serverMaxWindowBits = serverMaxWindowBits;
        this.clientMaxWindowBits = clientMaxWindowBits;
    }

    @Override
    public WsDecoder decoder() {
        return Ws.deflateDecoder(new Inflate(0, this.serverMaxWindowBits));
    }

    @Override
    public WsEncoder encoder() {
        int flush = this.clientNoContextTakeover ? 3 : 2;
        return Ws.deflateEncoderMasked(new Deflate(0, this.clientCompressionLevel, this.clientMaxWindowBits), flush);
    }

    @Override
    public WsEngine extension(WebSocketExtension extension, WsEngineSettings settings) {
        return this;
    }

    static WsDeflateClientEngine from(WebSocketExtension extension, WsEngineSettings settings) {
        boolean clientNoContextTakeover = false;
        int serverMaxWindowBits = 15;
        int clientMaxWindowBits = 15;
        for (WebSocketParam param : extension.params()) {
            String key = param.key();
            String value = param.value();
            if ("client_no_context_takeover".equals(key)) {
                clientNoContextTakeover = true;
                continue;
            }
            if ("server_max_window_bits".equals(key)) {
                try {
                    serverMaxWindowBits = Integer.parseInt(value);
                    continue;
                }
                catch (NumberFormatException cause) {
                    throw new WsException("invalid permessage-deflate; " + param.toHttp());
                }
            }
            if ("client_max_window_bits".equals(key)) {
                try {
                    clientMaxWindowBits = Integer.parseInt(value);
                    continue;
                }
                catch (NumberFormatException cause) {
                    throw new WsException("invalid permessage-deflate; " + param.toHttp());
                }
            }
            throw new WsException("invalid permessage-deflate; " + param.toHttp());
        }
        return new WsDeflateClientEngine(settings.clientCompressionLevel, clientNoContextTakeover, serverMaxWindowBits, clientMaxWindowBits);
    }
}

