/*
 * Decompiled with CFR 0.152.
 */
package swim.ws;

import swim.codec.Encoder;
import swim.codec.EncoderException;
import swim.codec.OutputBuffer;
import swim.ws.WsFrame;
import swim.ws.WsFrameEncoder;
import swim.ws.WsOpcode;

public abstract class WsEncoder {
    public abstract boolean isMasked();

    public abstract void maskingKey(byte[] var1);

    public <T> Encoder<?, WsFrame<T>> frameEncoder(WsFrame<T> frame) {
        WsOpcode opcode = frame.opcode();
        switch (opcode) {
            case CONTINUATION: {
                return Encoder.error((Throwable)new EncoderException("invalid opcode: " + opcode));
            }
            case TEXT: {
                return this.textFrameEncoder(frame);
            }
            case BINARY: {
                return this.binaryFrameEncoder(frame);
            }
            case CLOSE: {
                return this.closeFrameEncoder(frame);
            }
            case PING: {
                return this.pingFrameEncoder(frame);
            }
            case PONG: {
                return this.pongFrameEncoder(frame);
            }
        }
        return Encoder.error((Throwable)new EncoderException("reserved opcode: " + opcode));
    }

    public <T> Encoder<?, WsFrame<T>> encodeFrame(WsFrame<T> frame, OutputBuffer<?> output) {
        WsOpcode opcode = frame.opcode();
        switch (opcode) {
            case CONTINUATION: {
                return Encoder.error((Throwable)new EncoderException("invalid opcode: " + opcode));
            }
            case TEXT: {
                return this.encodeTextFrame(frame, output);
            }
            case BINARY: {
                return this.encodeBinaryFrame(frame, output);
            }
            case CLOSE: {
                return this.encodeCloseFrame(frame, output);
            }
            case PING: {
                return this.encodePingFrame(frame, output);
            }
            case PONG: {
                return this.encodePongFrame(frame, output);
            }
        }
        return Encoder.error((Throwable)new EncoderException("reserved opcode: " + opcode));
    }

    public <T> Encoder<?, WsFrame<T>> textFrameEncoder(WsFrame<T> frame) {
        return new WsFrameEncoder<T>(this, frame);
    }

    public <T> Encoder<?, WsFrame<T>> encodeTextFrame(WsFrame<T> frame, OutputBuffer<?> output) {
        return WsFrameEncoder.encode(output, this, frame);
    }

    public <T> Encoder<?, WsFrame<T>> binaryFrameEncoder(WsFrame<T> frame) {
        return new WsFrameEncoder<T>(this, frame);
    }

    public <T> Encoder<?, WsFrame<T>> encodeBinaryFrame(WsFrame<T> frame, OutputBuffer<?> output) {
        return WsFrameEncoder.encode(output, this, frame);
    }

    public <T> Encoder<?, WsFrame<T>> closeFrameEncoder(WsFrame<T> frame) {
        return new WsFrameEncoder<T>(this, frame);
    }

    public <T> Encoder<?, WsFrame<T>> encodeCloseFrame(WsFrame<T> frame, OutputBuffer<?> output) {
        return WsFrameEncoder.encode(output, this, frame);
    }

    public <T> Encoder<?, WsFrame<T>> pingFrameEncoder(WsFrame<T> frame) {
        return new WsFrameEncoder<T>(this, frame);
    }

    public <T> Encoder<?, WsFrame<T>> encodePingFrame(WsFrame<T> frame, OutputBuffer<?> output) {
        return WsFrameEncoder.encode(output, this, frame);
    }

    public <T> Encoder<?, WsFrame<T>> pongFrameEncoder(WsFrame<T> frame) {
        return new WsFrameEncoder<T>(this, frame);
    }

    public <T> Encoder<?, WsFrame<T>> encodePongFrame(WsFrame<T> frame, OutputBuffer<?> output) {
        return WsFrameEncoder.encode(output, this, frame);
    }
}

