/*
 * Decompiled with CFR 0.152.
 */
package swim.ws;

import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;
import swim.ws.WsEngineSettings;

final class WsEngineSettingsForm
extends Form<WsEngineSettings> {
    WsEngineSettingsForm() {
    }

    public WsEngineSettings unit() {
        return WsEngineSettings.standard();
    }

    public Class<?> type() {
        return WsEngineSettings.class;
    }

    public Item mold(WsEngineSettings settings) {
        if (settings != null) {
            WsEngineSettings standard = WsEngineSettings.standard();
            Record record = Record.create((int)8);
            if (settings.maxFrameSize != standard.maxFrameSize) {
                record.slot("maxFrameSize", settings.maxFrameSize);
            }
            if (settings.maxMessageSize != standard.maxMessageSize) {
                record.slot("maxMessageSize", settings.maxMessageSize);
            }
            if (settings.serverCompressionLevel != standard.serverCompressionLevel) {
                record.slot("serverCompressionLevel", settings.serverCompressionLevel);
            }
            if (settings.clientCompressionLevel != standard.clientCompressionLevel) {
                record.slot("clientCompressionLevel", settings.clientCompressionLevel);
            }
            if (settings.serverNoContextTakeover != standard.serverNoContextTakeover) {
                record.slot("serverNoContextTakeover", settings.serverNoContextTakeover);
            }
            if (settings.clientNoContextTakeover != standard.clientNoContextTakeover) {
                record.slot("clientNoContextTakeover", settings.clientNoContextTakeover);
            }
            if (settings.serverMaxWindowBits != standard.serverMaxWindowBits) {
                record.slot("serverMaxWindowBits", settings.serverMaxWindowBits);
            }
            if (settings.clientMaxWindowBits != standard.clientMaxWindowBits) {
                record.slot("clientMaxWindowBits", settings.clientMaxWindowBits);
            }
            return record;
        }
        return Item.extant();
    }

    public WsEngineSettings cast(Item item) {
        Value value = item.toValue();
        WsEngineSettings standard = WsEngineSettings.standard();
        int maxFrameSize = value.get("maxFrameSize").intValue(standard.maxFrameSize);
        int maxMessageSize = value.get("maxMessageSize").intValue(standard.maxMessageSize);
        int serverCompressionLevel = value.get("serverCompressionLevel").intValue(standard.serverCompressionLevel);
        int clientCompressionLevel = value.get("clientCompressionLevel").intValue(standard.clientCompressionLevel);
        boolean serverNoContextTakeover = value.get("serverNoContextTakeover").booleanValue(standard.serverNoContextTakeover);
        boolean clientNoContextTakeover = value.get("clientNoContextTakeover").booleanValue(standard.clientNoContextTakeover);
        int serverMaxWindowBits = value.get("serverMaxWindowBits").intValue(standard.serverMaxWindowBits);
        int clientMaxWindowBits = value.get("clientMaxWindowBits").intValue(standard.clientMaxWindowBits);
        return new WsEngineSettings(maxFrameSize, maxMessageSize, serverCompressionLevel, clientCompressionLevel, serverNoContextTakeover, clientNoContextTakeover, serverMaxWindowBits, clientMaxWindowBits);
    }
}

