/*
 * Decompiled with CFR 0.152.
 */
package swim.ws;

import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.InputBuffer;
import swim.ws.WsDecoder;
import swim.ws.WsFrame;

final class WsOpcodeDecoder<O>
extends Decoder<WsFrame<O>> {
    final WsDecoder ws;
    final Decoder<O> content;

    WsOpcodeDecoder(WsDecoder ws, Decoder<O> content) {
        this.ws = ws;
        this.content = content;
    }

    public Decoder<WsFrame<O>> feed(InputBuffer input) {
        return WsOpcodeDecoder.decode(input, this.ws, this.content);
    }

    static <O> Decoder<WsFrame<O>> decode(InputBuffer input, WsDecoder ws, Decoder<O> content) {
        if (input.isCont()) {
            int finRsvOp = input.head();
            return ws.decodeFrame(finRsvOp, content, input);
        }
        if (input.isDone()) {
            return WsOpcodeDecoder.error((Throwable)new DecoderException("incomplete"));
        }
        if (input.isError()) {
            return WsOpcodeDecoder.error((Throwable)input.trap());
        }
        return new WsOpcodeDecoder<O>(ws, content);
    }
}

