/*
 * Decompiled with CFR 0.152.
 */
package swim.ws;

import swim.collections.FingerTrieSeq;
import swim.http.HttpHeader;
import swim.http.HttpRequest;
import swim.http.HttpResponse;
import swim.http.HttpStatus;
import swim.http.UpgradeProtocol;
import swim.http.WebSocketExtension;
import swim.http.header.Connection;
import swim.http.header.Host;
import swim.http.header.SecWebSocketAccept;
import swim.http.header.SecWebSocketExtensions;
import swim.http.header.SecWebSocketKey;
import swim.http.header.SecWebSocketProtocol;
import swim.http.header.SecWebSocketVersion;
import swim.http.header.Upgrade;
import swim.uri.Uri;
import swim.uri.UriAuthority;
import swim.uri.UriPath;
import swim.uri.UriQuery;
import swim.util.Builder;
import swim.ws.WsEngineSettings;
import swim.ws.WsResponse;

public class WsRequest {
    protected final HttpRequest<?> httpRequest;
    protected final SecWebSocketKey key;
    protected final FingerTrieSeq<String> protocols;
    protected final FingerTrieSeq<WebSocketExtension> extensions;

    public WsRequest(HttpRequest<?> httpRequest, SecWebSocketKey key, FingerTrieSeq<String> protocols, FingerTrieSeq<WebSocketExtension> extensions) {
        this.httpRequest = httpRequest;
        this.key = key;
        this.protocols = protocols;
        this.extensions = extensions;
    }

    public final HttpRequest<?> httpRequest() {
        return this.httpRequest;
    }

    public final SecWebSocketKey key() {
        return this.key;
    }

    public final FingerTrieSeq<String> protocols() {
        return this.protocols;
    }

    public final FingerTrieSeq<WebSocketExtension> extensions() {
        return this.extensions;
    }

    public HttpResponse<?> httpResponse(String protocol, FingerTrieSeq<WebSocketExtension> extensions, FingerTrieSeq<HttpHeader> headers) {
        Builder responseHeaders = FingerTrieSeq.builder();
        responseHeaders.add((Object)Connection.upgrade());
        responseHeaders.add((Object)Upgrade.websocket());
        responseHeaders.add((Object)this.key.accept());
        if (protocol != null) {
            responseHeaders.add((Object)SecWebSocketProtocol.from((String[])new String[]{protocol}));
        }
        if (!extensions.isEmpty()) {
            responseHeaders.add((Object)SecWebSocketExtensions.from(extensions));
        }
        responseHeaders.addAll(headers);
        return HttpResponse.from((HttpStatus)HttpStatus.SWITCHING_PROTOCOLS, (FingerTrieSeq)((FingerTrieSeq)responseHeaders.bind()));
    }

    public HttpResponse<?> httpResponse(String protocol, HttpHeader ... headers) {
        return this.httpResponse(protocol, (FingerTrieSeq<WebSocketExtension>)FingerTrieSeq.empty(), (FingerTrieSeq<HttpHeader>)FingerTrieSeq.of((Object[])headers));
    }

    public HttpResponse<?> httpResponse(String protocol) {
        return this.httpResponse(protocol, (FingerTrieSeq<WebSocketExtension>)FingerTrieSeq.empty(), (FingerTrieSeq<HttpHeader>)FingerTrieSeq.empty());
    }

    public HttpResponse<?> httpResponse(FingerTrieSeq<HttpHeader> headers) {
        return this.httpResponse(null, (FingerTrieSeq<WebSocketExtension>)FingerTrieSeq.empty(), headers);
    }

    public HttpResponse<?> httpResponse(HttpHeader ... headers) {
        return this.httpResponse(null, (FingerTrieSeq<WebSocketExtension>)FingerTrieSeq.empty(), (FingerTrieSeq<HttpHeader>)FingerTrieSeq.of((Object[])headers));
    }

    public HttpResponse<?> httpResponse() {
        return this.httpResponse(null, (FingerTrieSeq<WebSocketExtension>)FingerTrieSeq.empty(), (FingerTrieSeq<HttpHeader>)FingerTrieSeq.empty());
    }

    public WsResponse accept(WsEngineSettings settings, String protocol, FingerTrieSeq<HttpHeader> headers) {
        FingerTrieSeq<WebSocketExtension> responseExtensions = settings.acceptExtensions(this.extensions);
        HttpResponse<?> httpResponse = this.httpResponse(protocol, responseExtensions, headers);
        return new WsResponse(this.httpRequest, httpResponse, protocol, responseExtensions);
    }

    public WsResponse accept(WsEngineSettings settings, String protocol, HttpHeader ... headers) {
        return this.accept(settings, protocol, (FingerTrieSeq<HttpHeader>)FingerTrieSeq.of((Object[])headers));
    }

    public WsResponse accept(WsEngineSettings settings, String protocol) {
        return this.accept(settings, protocol, (FingerTrieSeq<HttpHeader>)FingerTrieSeq.empty());
    }

    public WsResponse accept(WsEngineSettings settings, FingerTrieSeq<HttpHeader> headers) {
        return this.accept(settings, null, headers);
    }

    public WsResponse accept(WsEngineSettings settings, HttpHeader ... headers) {
        return this.accept(settings, null, (FingerTrieSeq<HttpHeader>)FingerTrieSeq.of((Object[])headers));
    }

    public WsResponse accept(WsEngineSettings settings) {
        return this.accept(settings, null, (FingerTrieSeq<HttpHeader>)FingerTrieSeq.empty());
    }

    public WsResponse accept(HttpResponse<?> httpResponse, WsEngineSettings settings) {
        boolean connectionUpgrade = false;
        boolean upgradeWebSocket = false;
        SecWebSocketAccept accept = null;
        String protocol = null;
        FingerTrieSeq extensions = FingerTrieSeq.empty();
        for (HttpHeader header : httpResponse.headers()) {
            if (header instanceof Connection && ((Connection)header).contains("Upgrade")) {
                connectionUpgrade = true;
                continue;
            }
            if (header instanceof Upgrade && ((Upgrade)header).supports(UpgradeProtocol.websocket())) {
                upgradeWebSocket = true;
                continue;
            }
            if (header instanceof SecWebSocketAccept) {
                accept = (SecWebSocketAccept)header;
                continue;
            }
            if (header instanceof SecWebSocketProtocol) {
                FingerTrieSeq protocols = ((SecWebSocketProtocol)header).protocols();
                if (protocols.isEmpty()) continue;
                protocol = (String)protocols.head();
                continue;
            }
            if (!(header instanceof SecWebSocketExtensions)) continue;
            extensions = ((SecWebSocketExtensions)header).extensions();
        }
        if (httpResponse.status().code() == 101 && connectionUpgrade && upgradeWebSocket && accept != null) {
            extensions = settings.acceptExtensions((FingerTrieSeq<WebSocketExtension>)extensions);
            return new WsResponse(this.httpRequest, httpResponse, protocol, (FingerTrieSeq<WebSocketExtension>)extensions);
        }
        return null;
    }

    public static WsRequest from(Uri uri, FingerTrieSeq<String> protocols, FingerTrieSeq<WebSocketExtension> extensions, FingerTrieSeq<HttpHeader> headers) {
        SecWebSocketKey key = SecWebSocketKey.generate();
        Builder requestHeaders = FingerTrieSeq.builder();
        requestHeaders.add((Object)Host.from((UriAuthority)uri.authority()));
        requestHeaders.add((Object)Connection.upgrade());
        requestHeaders.add((Object)Upgrade.websocket());
        requestHeaders.add((Object)SecWebSocketVersion.version13());
        requestHeaders.add((Object)key);
        if (!protocols.isEmpty()) {
            requestHeaders.add((Object)SecWebSocketProtocol.from(protocols));
        }
        if (!extensions.isEmpty()) {
            requestHeaders.add((Object)SecWebSocketExtensions.from(extensions));
        }
        if (headers != null) {
            requestHeaders.addAll(headers);
        }
        UriPath requestPath = uri.path().isEmpty() ? UriPath.slash() : uri.path();
        Uri requestUri = Uri.from(null, null, (UriPath)requestPath, (UriQuery)uri.query(), null);
        HttpRequest httpRequest = HttpRequest.get((Uri)requestUri, (FingerTrieSeq)((FingerTrieSeq)requestHeaders.bind()));
        return new WsRequest(httpRequest, key, protocols, extensions);
    }

    public static WsRequest from(Uri uri, FingerTrieSeq<String> protocols, HttpHeader ... headers) {
        return WsRequest.from(uri, protocols, (FingerTrieSeq<WebSocketExtension>)FingerTrieSeq.empty(), (FingerTrieSeq<HttpHeader>)FingerTrieSeq.of((Object[])headers));
    }

    public static WsRequest from(Uri uri, FingerTrieSeq<String> protocols) {
        return WsRequest.from(uri, protocols, (FingerTrieSeq<WebSocketExtension>)FingerTrieSeq.empty(), (FingerTrieSeq<HttpHeader>)FingerTrieSeq.empty());
    }

    public static WsRequest from(Uri uri, HttpHeader ... headers) {
        return WsRequest.from(uri, (FingerTrieSeq<String>)FingerTrieSeq.empty(), (FingerTrieSeq<WebSocketExtension>)FingerTrieSeq.empty(), (FingerTrieSeq<HttpHeader>)FingerTrieSeq.of((Object[])headers));
    }

    public static WsRequest from(Uri uri) {
        return WsRequest.from(uri, (FingerTrieSeq<String>)FingerTrieSeq.empty(), (FingerTrieSeq<WebSocketExtension>)FingerTrieSeq.empty(), (FingerTrieSeq<HttpHeader>)FingerTrieSeq.empty());
    }

    public static WsRequest from(HttpRequest<?> httpRequest) {
        boolean connectionUpgrade = false;
        boolean upgradeWebSocket = false;
        SecWebSocketKey key = null;
        FingerTrieSeq protocols = FingerTrieSeq.empty();
        FingerTrieSeq extensions = FingerTrieSeq.empty();
        for (HttpHeader header : httpRequest.headers()) {
            if (header instanceof Connection && ((Connection)header).contains("Upgrade")) {
                connectionUpgrade = true;
                continue;
            }
            if (header instanceof Upgrade && ((Upgrade)header).supports(UpgradeProtocol.websocket())) {
                upgradeWebSocket = true;
                continue;
            }
            if (header instanceof SecWebSocketKey) {
                key = (SecWebSocketKey)header;
                continue;
            }
            if (header instanceof SecWebSocketProtocol) {
                protocols = ((SecWebSocketProtocol)header).protocols();
                continue;
            }
            if (!(header instanceof SecWebSocketExtensions)) continue;
            extensions = ((SecWebSocketExtensions)header).extensions();
        }
        if (connectionUpgrade && upgradeWebSocket && key != null) {
            return new WsRequest(httpRequest, key, (FingerTrieSeq<String>)protocols, (FingerTrieSeq<WebSocketExtension>)extensions);
        }
        return null;
    }
}

