/*
 * Decompiled with CFR 0.152.
 */
package swim.ws;

import swim.codec.Debug;
import swim.codec.Decoder;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.InputBuffer;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.util.Murmur3;
import swim.ws.WsStatusDecoder;
import swim.ws.WsStatusEncoder;

public final class WsStatus
implements Debug {
    final int code;
    final String reason;
    private static int hashSeed;

    WsStatus(int code, String reason) {
        this.code = code;
        this.reason = reason;
    }

    public int code() {
        return this.code;
    }

    public String reason() {
        return this.reason;
    }

    public Encoder<?, WsStatus> encoder() {
        return new WsStatusEncoder(this);
    }

    public Encoder<?, WsStatus> encode(OutputBuffer<?> output) {
        return WsStatusEncoder.encode(output, this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof WsStatus) {
            WsStatus that = (WsStatus)other;
            return this.code == that.code && this.reason.equals(that.reason);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(WsStatus.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.code), (int)this.reason.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("WsStatus").write(46).write("from").write(40).debug((Object)this.code);
        if (!this.reason.isEmpty()) {
            output = output.write(", ").debug((Object)this.reason);
        }
        output = output.write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static WsStatus from(int code, String reason) {
        return new WsStatus(code, reason);
    }

    public static WsStatus from(int code) {
        return new WsStatus(code, "");
    }

    public static Decoder<WsStatus> decoder() {
        return new WsStatusDecoder();
    }

    public static Decoder<WsStatus> decode(InputBuffer input) {
        return WsStatusDecoder.decode(input);
    }
}

