/*
 * Decompiled with CFR 0.152.
 */
package swim.ws;

import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.Input;
import swim.codec.InputBuffer;
import swim.codec.Utf8;
import swim.ws.WsStatus;

final class WsStatusDecoder
extends Decoder<WsStatus> {
    final int code;
    final Decoder<String> reason;
    final int step;

    WsStatusDecoder(int code, Decoder<String> reason, int step) {
        this.code = code;
        this.reason = reason;
        this.step = step;
    }

    WsStatusDecoder() {
        this(0, null, 1);
    }

    public Decoder<WsStatus> feed(InputBuffer input) {
        return WsStatusDecoder.decode(input, this.code, this.reason, this.step);
    }

    static Decoder<WsStatus> decode(InputBuffer input, int code, Decoder<String> reason, int step) {
        if (step == 1 && input.isCont()) {
            code = input.head() << 8;
            input = input.step();
            step = 2;
        }
        if (step == 2 && input.isCont()) {
            code |= input.head();
            input = input.step();
            step = 3;
        }
        if (step == 3) {
            if ((reason = reason == null ? Utf8.parseString((Input)input) : reason.feed(input)).isDone()) {
                return WsStatusDecoder.done((Object)new WsStatus(code, (String)reason.bind()));
            }
            if (reason.isError()) {
                return reason.asError();
            }
        }
        if (input.isDone()) {
            return WsStatusDecoder.error((Throwable)new DecoderException("incomplete"));
        }
        if (input.isError()) {
            return WsStatusDecoder.error((Throwable)input.trap());
        }
        return new WsStatusDecoder(code, (Decoder<String>)reason, step);
    }

    static Decoder<WsStatus> decode(InputBuffer input) {
        return WsStatusDecoder.decode(input, 0, null, 1);
    }
}

