/*
 * Decompiled with CFR 0.152.
 */
package swim.ws;

import swim.codec.Encoder;
import swim.codec.EncoderException;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.codec.Utf8;
import swim.ws.WsStatus;

final class WsStatusEncoder
extends Encoder<Object, WsStatus> {
    final WsStatus status;
    final Encoder<?, ?> part;
    final int step;

    WsStatusEncoder(WsStatus status, Encoder<?, ?> part, int step) {
        this.status = status;
        this.part = part;
        this.step = step;
    }

    WsStatusEncoder(WsStatus status) {
        this(status, null, 1);
    }

    public Encoder<Object, WsStatus> pull(OutputBuffer<?> output) {
        return WsStatusEncoder.encode(output, this.status, this.part, this.step);
    }

    static Encoder<Object, WsStatus> encode(OutputBuffer<?> output, WsStatus status, Encoder<?, ?> part, int step) {
        if (step == 1 && output.isCont()) {
            output = output.write(status.code >>> 8);
            step = 2;
        }
        if (step == 2 && output.isCont()) {
            output = output.write(status.code);
            step = 3;
        }
        if (step == 3) {
            if ((part = part == null ? Utf8.writeString((Object)status.reason, (Output)output) : part.pull(output)).isDone()) {
                return WsStatusEncoder.done((Object)status);
            }
            if (part.isError()) {
                return part.asError();
            }
        }
        if (output.isDone()) {
            return WsStatusEncoder.error((Throwable)new EncoderException("truncated"));
        }
        if (output.isError()) {
            return WsStatusEncoder.error((Throwable)output.trap());
        }
        return new WsStatusEncoder(status, (Encoder<?, ?>)part, step);
    }

    static Encoder<Object, WsStatus> encode(OutputBuffer<?> output, WsStatus status) {
        return WsStatusEncoder.encode(output, status, null, 1);
    }
}

