/*
 * Decompiled with CFR 0.152.
 */
package swim.io.ws;

import swim.io.http.HttpSettings;
import swim.io.ws.WsSettings;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;

final class WsSettingsForm
extends Form<WsSettings> {
    WsSettingsForm() {
    }

    public WsSettings unit() {
        return WsSettings.standard();
    }

    public Class<?> type() {
        return WsSettings.class;
    }

    public Item mold(WsSettings settings) {
        if (settings != null) {
            WsSettings standard = WsSettings.standard();
            Record websocket = Record.create((int)9).attr("websocket");
            if (settings.maxFrameSize() != standard.maxFrameSize()) {
                websocket.slot("maxFrameSize", settings.maxFrameSize());
            }
            if (settings.maxMessageSize() != standard.maxMessageSize()) {
                websocket.slot("maxMessageSize", settings.maxMessageSize());
            }
            if (settings.serverCompressionLevel() != standard.serverCompressionLevel()) {
                websocket.slot("serverCompressionLevel", settings.serverCompressionLevel());
            }
            if (settings.clientCompressionLevel() != standard.clientCompressionLevel()) {
                websocket.slot("clientCompressionLevel", settings.clientCompressionLevel());
            }
            if (settings.serverNoContextTakeover() != standard.serverNoContextTakeover()) {
                websocket.slot("serverNoContextTakeover", settings.serverNoContextTakeover());
            }
            if (settings.clientNoContextTakeover() != standard.clientNoContextTakeover()) {
                websocket.slot("clientNoContextTakeover", settings.clientNoContextTakeover());
            }
            if (settings.serverMaxWindowBits() != standard.serverMaxWindowBits()) {
                websocket.slot("serverMaxWindowBits", settings.serverMaxWindowBits());
            }
            if (settings.clientMaxWindowBits() != standard.clientMaxWindowBits()) {
                websocket.slot("clientMaxWindowBits", settings.clientMaxWindowBits());
            }
            return Record.of((Object)websocket).concat(HttpSettings.form().mold((Object)settings.httpSettings));
        }
        return Item.extant();
    }

    public WsSettings cast(Item item) {
        Value value = item.toValue();
        WsSettings standard = WsSettings.standard();
        HttpSettings httpSettings = (HttpSettings)HttpSettings.form().cast(item);
        int maxFrameSize = standard.maxFrameSize();
        int maxMessageSize = standard.maxMessageSize();
        int serverCompressionLevel = standard.serverCompressionLevel();
        int clientCompressionLevel = standard.clientCompressionLevel();
        boolean serverNoContextTakeover = standard.serverNoContextTakeover();
        boolean clientNoContextTakeover = standard.clientNoContextTakeover();
        int serverMaxWindowBits = standard.serverMaxWindowBits();
        int clientMaxWindowBits = standard.clientMaxWindowBits();
        for (Item member : value) {
            if (!member.getAttr("websocket").isDefined()) continue;
            maxFrameSize = member.get("maxFrameSize").intValue(maxFrameSize);
            maxMessageSize = member.get("maxMessageSize").intValue(maxMessageSize);
            serverCompressionLevel = member.get("serverCompressionLevel").intValue(serverCompressionLevel);
            clientCompressionLevel = member.get("clientCompressionLevel").intValue(clientCompressionLevel);
            serverNoContextTakeover = member.get("serverNoContextTakeover").booleanValue(serverNoContextTakeover);
            clientNoContextTakeover = member.get("clientNoContextTakeover").booleanValue(clientNoContextTakeover);
            serverMaxWindowBits = member.get("serverMaxWindowBits").intValue(serverMaxWindowBits);
            clientMaxWindowBits = member.get("clientMaxWindowBits").intValue(clientMaxWindowBits);
        }
        return new WsSettings(httpSettings, maxFrameSize, maxMessageSize, serverCompressionLevel, clientCompressionLevel, serverNoContextTakeover, clientNoContextTakeover, serverMaxWindowBits, clientMaxWindowBits);
    }
}

