/*
 * Decompiled with CFR 0.152.
 */
package swim.io.ws;

import swim.codec.Decoder;
import swim.http.HttpRequest;
import swim.http.HttpResponse;
import swim.io.Socket;
import swim.io.SocketModem;
import swim.io.http.AbstractHttpResponder;
import swim.io.ws.WebSocket;
import swim.io.ws.WebSocketModem;
import swim.io.ws.WsSettings;
import swim.ws.WsDecoder;
import swim.ws.WsEncoder;
import swim.ws.WsEngine;
import swim.ws.WsEngineSettings;
import swim.ws.WsResponse;

public class WsUpgradeResponder
extends AbstractHttpResponder<Object> {
    final WebSocket<?, ?> webSocket;
    final WsResponse wsResponse;
    final WsSettings wsSettings;

    public WsUpgradeResponder(WebSocket<?, ?> webSocket, WsResponse wsResponse, WsSettings wsSettings) {
        this.webSocket = webSocket;
        this.wsResponse = wsResponse;
        this.wsSettings = wsSettings;
    }

    public final WebSocket<?, ?> webSocket() {
        return this.webSocket;
    }

    public final WsResponse wsResponse() {
        return this.wsResponse;
    }

    public final WsSettings wsSettings() {
        return this.wsSettings;
    }

    public Socket createSocket(WsEngine engine) {
        WebSocket<?, ?> socket = this.webSocket;
        WsDecoder decoder = engine.decoder();
        WsEncoder encoder = engine.encoder();
        return new SocketModem(new WebSocketModem(socket, this.wsSettings, decoder, encoder));
    }

    public Decoder<Object> contentDecoder(HttpRequest<?> httpRequest) {
        return Decoder.done();
    }

    public void didRequest(HttpRequest<Object> httpRequest) {
        this.writeResponse(this.wsResponse.httpResponse());
    }

    public void didRespond(HttpResponse<?> httpResponse) {
        WsEngine engine = this.wsResponse.serverEngine((WsEngineSettings)this.wsSettings);
        Socket socket = this.createSocket(engine);
        this.become(socket);
        this.webSocket.didConnect();
        this.webSocket.didUpgrade(this.wsResponse.httpRequest(), httpResponse);
    }

    public void didDisconnect() {
        this.webSocket.didDisconnect();
    }
}

