/*
 * Decompiled with CFR 0.152.
 */
package swim.json;

import java.math.BigInteger;
import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Unicode;
import swim.json.ArrayParser;
import swim.json.IdentParser;
import swim.json.Json;
import swim.json.NumberParser;
import swim.json.ObjectParser;
import swim.json.StringParser;
import swim.json.ValueParser;
import swim.util.Builder;

public abstract class JsonParser<I, V> {
    public abstract I item(V var1);

    public abstract V value(I var1);

    public abstract I field(V var1, V var2);

    public abstract Builder<I, V> objectBuilder();

    public abstract Builder<I, V> arrayBuilder();

    public abstract Output<V> textOutput();

    public abstract V ident(V var1);

    public abstract V num(int var1);

    public abstract V num(long var1);

    public abstract V num(float var1);

    public abstract V num(double var1);

    public abstract V num(BigInteger var1);

    public abstract V num(String var1);

    public abstract V uint32(int var1);

    public abstract V uint64(long var1);

    public abstract V bool(boolean var1);

    public Parser<V> parseValue(Input input) {
        return ValueParser.parse(input, this);
    }

    public Parser<V> parseObject(Input input) {
        return ObjectParser.parse(input, this);
    }

    public Parser<V> parseArray(Input input) {
        return ArrayParser.parse(input, this);
    }

    public Parser<V> parseIdent(Input input) {
        return IdentParser.parse(input, this);
    }

    public Parser<V> parseString(Input input) {
        return StringParser.parse(input, this);
    }

    public Parser<V> parseNumber(Input input) {
        return NumberParser.parse(input, this);
    }

    public Parser<V> valueParser() {
        return new ValueParser(this);
    }

    public Parser<V> objectParser() {
        return new ObjectParser(this);
    }

    public Parser<V> arrayParser() {
        return new ArrayParser(this);
    }

    public V parseValueString(String string) {
        Input input = Unicode.stringInput((String)string);
        while (input.isCont() && Json.isWhitespace(input.head())) {
            input = input.step();
        }
        Parser parser = this.parseValue(input);
        if (parser.isDone()) {
            while (input.isCont() && Json.isWhitespace(input.head())) {
                input = input.step();
            }
        }
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        } else if (input.isError()) {
            parser = Parser.error((Throwable)input.trap());
        }
        return (V)parser.bind();
    }

    public V parseObjectString(String string) {
        Input input = Unicode.stringInput((String)string);
        while (input.isCont() && Json.isWhitespace(input.head())) {
            input = input.step();
        }
        Parser parser = this.parseObject(input);
        if (parser.isDone()) {
            while (input.isCont() && Json.isWhitespace(input.head())) {
                input = input.step();
            }
        }
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        } else if (input.isError()) {
            parser = Parser.error((Throwable)input.trap());
        }
        return (V)parser.bind();
    }
}

