/*
 * Decompiled with CFR 0.152.
 */
package swim.json;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Iterator;
import swim.codec.Base10;
import swim.codec.Base16;
import swim.codec.Output;
import swim.codec.Unicode;
import swim.codec.Writer;
import swim.json.ArrayWriter;
import swim.json.DataWriter;
import swim.json.FieldWriter;
import swim.json.ObjectWriter;
import swim.json.StringWriter;

public abstract class JsonWriter<I, V> {
    public abstract Iterator<I> items(I var1);

    public abstract I item(V var1);

    public abstract V key(I var1);

    public abstract V value(I var1);

    public abstract Writer<?, ?> writeItem(I var1, Output<?> var2);

    public abstract Writer<?, ?> writeField(I var1, Output<?> var2, int var3);

    public abstract Writer<?, ?> writeValue(I var1, Output<?> var2, int var3);

    public abstract Writer<?, ?> writeValue(V var1, Output<?> var2);

    public Writer<?, ?> writeField(V key, V value, Output<?> output) {
        return FieldWriter.write(output, this, key, value);
    }

    public Writer<?, ?> writeArray(I item, Output<?> output) {
        return ArrayWriter.write(output, this, this.items(item));
    }

    public Writer<?, ?> writeObject(I item, Output<?> output) {
        return ObjectWriter.write(output, this, this.items(item));
    }

    public Writer<?, ?> writeData(ByteBuffer value, Output<?> output) {
        if (value != null) {
            return DataWriter.write(output, value);
        }
        return Unicode.writeString((Object)"\"\"", output);
    }

    public Writer<?, ?> writeText(String value, Output<?> output) {
        return StringWriter.write(output, value);
    }

    public Writer<?, ?> writeNum(int value, Output<?> output) {
        return Base10.writeInt((int)value, output);
    }

    public Writer<?, ?> writeNum(long value, Output<?> output) {
        return Base10.writeLong((long)value, output);
    }

    public Writer<?, ?> writeNum(float value, Output<?> output) {
        return Base10.writeFloat((float)value, output);
    }

    public Writer<?, ?> writeNum(double value, Output<?> output) {
        return Base10.writeDouble((double)value, output);
    }

    public Writer<?, ?> writeNum(BigInteger value, Output<?> output) {
        return Unicode.writeString((Object)value, output);
    }

    public Writer<?, ?> writeUint32(int value, Output<?> output) {
        return Base16.lowercase().writeIntLiteral(value, output, 8);
    }

    public Writer<?, ?> writeUint64(long value, Output<?> output) {
        return Base16.lowercase().writeLongLiteral(value, output, 16);
    }

    public Writer<?, ?> writeBool(boolean value, Output<?> output) {
        return Unicode.writeString((Object)(value ? "true" : "false"), output);
    }

    public Writer<?, ?> writeNull(Output<?> output) {
        return Unicode.writeString((Object)"null", output);
    }

    public Writer<?, ?> writeUndefined(Output<?> output) {
        return Unicode.writeString((Object)"undefined", output);
    }
}

