/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.downlink;

import java.net.InetSocketAddress;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.api.Link;
import swim.api.SwimContext;
import swim.api.auth.Identity;
import swim.api.downlink.Downlink;
import swim.api.downlink.function.DidLink;
import swim.api.downlink.function.DidReceive;
import swim.api.downlink.function.DidSync;
import swim.api.downlink.function.DidUnlink;
import swim.api.downlink.function.WillCommand;
import swim.api.downlink.function.WillLink;
import swim.api.downlink.function.WillReceive;
import swim.api.downlink.function.WillSync;
import swim.api.downlink.function.WillUnlink;
import swim.api.function.DidClose;
import swim.api.function.DidConnect;
import swim.api.function.DidDisconnect;
import swim.api.function.DidFail;
import swim.collections.FingerTrieSeq;
import swim.concurrent.Conts;
import swim.concurrent.Stage;
import swim.runtime.CellContext;
import swim.runtime.downlink.DownlinkModel;
import swim.structure.Value;
import swim.uri.Uri;
import swim.warp.CommandMessage;
import swim.warp.EventMessage;
import swim.warp.LinkRequest;
import swim.warp.LinkedResponse;
import swim.warp.SyncRequest;
import swim.warp.SyncedResponse;
import swim.warp.UnlinkRequest;
import swim.warp.UnlinkedResponse;

public abstract class DownlinkView
implements Downlink {
    protected final CellContext cellContext;
    protected final Stage stage;
    protected final Uri meshUri;
    protected final Uri hostUri;
    protected final Uri nodeUri;
    protected final Uri laneUri;
    protected final float prio;
    protected final float rate;
    protected final Value body;
    protected volatile int flags;
    protected volatile Object observers;
    protected static final int KEEP_LINKED = 1;
    protected static final int KEEP_SYNCED = 2;
    static final AtomicReferenceFieldUpdater<DownlinkView, Object> OBSERVERS = AtomicReferenceFieldUpdater.newUpdater(DownlinkView.class, Object.class, "observers");

    public DownlinkView(CellContext cellContext, Stage stage, Uri meshUri, Uri hostUri, Uri nodeUri, Uri laneUri, float prio, float rate, Value body, int flags, Object observers) {
        this.cellContext = cellContext;
        this.stage = stage;
        this.meshUri = meshUri.isDefined() ? meshUri : hostUri;
        this.hostUri = hostUri;
        this.nodeUri = nodeUri;
        this.laneUri = laneUri;
        this.prio = prio;
        this.rate = rate;
        this.body = body;
        this.flags = flags;
        this.observers = observers;
    }

    public final CellContext cellContext() {
        return this.cellContext;
    }

    public abstract DownlinkModel<?> downlinkModel();

    public final Stage stage() {
        return this.stage;
    }

    public final Uri meshUri() {
        return this.meshUri;
    }

    public final Uri hostUri() {
        return this.hostUri;
    }

    public abstract DownlinkView hostUri(Uri var1);

    public abstract DownlinkView hostUri(String var1);

    public final Uri nodeUri() {
        return this.nodeUri;
    }

    public abstract DownlinkView nodeUri(Uri var1);

    public abstract DownlinkView nodeUri(String var1);

    public final Uri laneUri() {
        return this.laneUri;
    }

    public abstract DownlinkView laneUri(Uri var1);

    public abstract DownlinkView laneUri(String var1);

    public final float prio() {
        return this.prio;
    }

    public abstract DownlinkView prio(float var1);

    public final float rate() {
        return this.rate;
    }

    public abstract DownlinkView rate(float var1);

    public final Value body() {
        return this.body;
    }

    public abstract DownlinkView body(Value var1);

    public final boolean keepLinked() {
        return (this.flags & 1) != 0;
    }

    public abstract DownlinkView keepLinked(boolean var1);

    public final boolean keepSynced() {
        return (this.flags & 2) != 0;
    }

    public abstract DownlinkView keepSynced(boolean var1);

    public boolean isConnected() {
        DownlinkModel<?> model = this.downlinkModel();
        return model != null && model.isConnected();
    }

    public boolean isRemote() {
        DownlinkModel<?> model = this.downlinkModel();
        return model != null && model.isRemote();
    }

    public boolean isSecure() {
        DownlinkModel<?> model = this.downlinkModel();
        return model != null && model.isSecure();
    }

    public String securityProtocol() {
        DownlinkModel<?> model = this.downlinkModel();
        if (model != null) {
            return model.securityProtocol();
        }
        return null;
    }

    public String cipherSuite() {
        DownlinkModel<?> model = this.downlinkModel();
        if (model != null) {
            return model.cipherSuite();
        }
        return null;
    }

    public InetSocketAddress localAddress() {
        DownlinkModel<?> model = this.downlinkModel();
        if (model != null) {
            return model.localAddress();
        }
        return null;
    }

    public Identity localIdentity() {
        DownlinkModel<?> model = this.downlinkModel();
        if (model != null) {
            return model.localIdentity();
        }
        return null;
    }

    public Principal localPrincipal() {
        DownlinkModel<?> model = this.downlinkModel();
        if (model != null) {
            return model.localPrincipal();
        }
        return null;
    }

    public Collection<Certificate> localCertificates() {
        DownlinkModel<?> model = this.downlinkModel();
        if (model != null) {
            return model.localCertificates();
        }
        return FingerTrieSeq.empty();
    }

    public InetSocketAddress remoteAddress() {
        DownlinkModel<?> model = this.downlinkModel();
        if (model != null) {
            return model.remoteAddress();
        }
        return null;
    }

    public Identity remoteIdentity() {
        DownlinkModel<?> model = this.downlinkModel();
        if (model != null) {
            return model.remoteIdentity();
        }
        return null;
    }

    public Principal remotePrincipal() {
        DownlinkModel<?> model = this.downlinkModel();
        if (model != null) {
            return model.remotePrincipal();
        }
        return null;
    }

    public Collection<Certificate> remoteCertificates() {
        DownlinkModel<?> model = this.downlinkModel();
        if (model != null) {
            return model.remoteCertificates();
        }
        return FingerTrieSeq.empty();
    }

    public DownlinkView observe(Object newObserver) {
        Object[] newObservers;
        Object oldObservers;
        do {
            if ((oldObservers = this.observers) == null) {
                newObservers = newObserver;
                continue;
            }
            if (!(oldObservers instanceof Object[])) {
                Object[] newArray = new Object[]{oldObservers, newObserver};
                newObservers = newArray;
                continue;
            }
            Object[] oldArray = (Object[])oldObservers;
            int oldCount = oldArray.length;
            Object[] newArray = new Object[oldCount + 1];
            System.arraycopy(oldArray, 0, newArray, 0, oldCount);
            newArray[oldCount] = newObserver;
            newObservers = newArray;
        } while (!OBSERVERS.compareAndSet(this, oldObservers, newObservers));
        return this;
    }

    public DownlinkView unobserve(Object oldObserver) {
        Object oldObservers;
        while ((oldObservers = this.observers) != null) {
            Object[] newObservers;
            if (!(oldObservers instanceof Object[])) {
                if (oldObservers != oldObserver) break;
                newObservers = null;
            } else {
                Object[] oldArray = (Object[])oldObservers;
                int oldCount = oldArray.length;
                if (oldCount == 2) {
                    if (oldArray[0] == oldObserver) {
                        newObservers = oldArray[1];
                    } else {
                        if (oldArray[1] != oldObserver) break;
                        newObservers = oldArray[0];
                    }
                } else {
                    int i;
                    for (i = 0; i < oldCount && oldArray[i] != oldObserver; ++i) {
                    }
                    if (i >= oldCount) break;
                    Object[] newArray = new Object[oldCount - 1];
                    System.arraycopy(oldArray, 0, newArray, 0, i);
                    System.arraycopy(oldArray, i + 1, newArray, i, oldCount - 1 - i);
                    newObservers = newArray;
                }
            }
            if (!OBSERVERS.compareAndSet(this, oldObservers, newObservers)) continue;
            break;
        }
        return this;
    }

    public abstract DownlinkView willReceive(WillReceive var1);

    public abstract DownlinkView didReceive(DidReceive var1);

    public abstract DownlinkView willCommand(WillCommand var1);

    public abstract DownlinkView willLink(WillLink var1);

    public abstract DownlinkView didLink(DidLink var1);

    public abstract DownlinkView willSync(WillSync var1);

    public abstract DownlinkView didSync(DidSync var1);

    public abstract DownlinkView willUnlink(WillUnlink var1);

    public abstract DownlinkView didUnlink(DidUnlink var1);

    public abstract DownlinkView didConnect(DidConnect var1);

    public abstract DownlinkView didDisconnect(DidDisconnect var1);

    public abstract DownlinkView didClose(DidClose var1);

    public abstract DownlinkView didFail(DidFail var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchWillReceive(Value body, boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        SwimContext.setLink((Link)this);
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof WillReceive)) break block12;
                        if (((WillReceive)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((WillReceive)observers).willReceive(body);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof WillReceive)) continue;
                        if (((WillReceive)observer).isPreemptive() == preemptive) {
                            try {
                                ((WillReceive)observer).willReceive(body);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.downlinkDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchDidReceive(Value body, boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        SwimContext.setLink((Link)this);
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof DidReceive)) break block12;
                        if (((DidReceive)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((DidReceive)observers).didReceive(body);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof DidReceive)) continue;
                        if (((DidReceive)observer).isPreemptive() == preemptive) {
                            try {
                                ((DidReceive)observer).didReceive(body);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.downlinkDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchWillCommand(Value body, boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        SwimContext.setLink((Link)this);
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof WillCommand)) break block12;
                        if (((WillCommand)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((WillCommand)observers).willCommand(body);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof WillCommand)) continue;
                        if (((WillCommand)observer).isPreemptive() == preemptive) {
                            try {
                                ((WillCommand)observer).willCommand(body);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.downlinkDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchWillLink(boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        SwimContext.setLink((Link)this);
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof WillLink)) break block12;
                        if (((WillLink)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((WillLink)observers).willLink();
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof WillLink)) continue;
                        if (((WillLink)observer).isPreemptive() == preemptive) {
                            try {
                                ((WillLink)observer).willLink();
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.downlinkDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchDidLink(boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        SwimContext.setLink((Link)this);
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof DidLink)) break block12;
                        if (((DidLink)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((DidLink)observers).didLink();
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof DidLink)) continue;
                        if (((DidLink)observer).isPreemptive() == preemptive) {
                            try {
                                ((DidLink)observer).didLink();
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.downlinkDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchWillSync(boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        SwimContext.setLink((Link)this);
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof WillSync)) break block12;
                        if (((WillSync)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((WillSync)observers).willSync();
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof WillSync)) continue;
                        if (((WillSync)observer).isPreemptive() == preemptive) {
                            try {
                                ((WillSync)observer).willSync();
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.downlinkDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchDidSync(boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        SwimContext.setLink((Link)this);
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof DidSync)) break block12;
                        if (((DidSync)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((DidSync)observers).didSync();
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof DidSync)) continue;
                        if (((DidSync)observer).isPreemptive() == preemptive) {
                            try {
                                ((DidSync)observer).didSync();
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.downlinkDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchWillUnlink(boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        SwimContext.setLink((Link)this);
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof WillUnlink)) break block12;
                        if (((WillUnlink)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((WillUnlink)observers).willUnlink();
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof WillUnlink)) continue;
                        if (((WillUnlink)observer).isPreemptive() == preemptive) {
                            try {
                                ((WillUnlink)observer).willUnlink();
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.downlinkDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchDidUnlink(boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        SwimContext.setLink((Link)this);
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof DidUnlink)) break block12;
                        if (((DidUnlink)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((DidUnlink)observers).didUnlink();
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof DidUnlink)) continue;
                        if (((DidUnlink)observer).isPreemptive() == preemptive) {
                            try {
                                ((DidUnlink)observer).didUnlink();
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.downlinkDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchDidConnect(boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        SwimContext.setLink((Link)this);
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof DidConnect)) break block12;
                        if (((DidConnect)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((DidConnect)observers).didConnect();
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof DidConnect)) continue;
                        if (((DidConnect)observer).isPreemptive() == preemptive) {
                            try {
                                ((DidConnect)observer).didConnect();
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.downlinkDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchDidDisconnect(boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        SwimContext.setLink((Link)this);
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof DidDisconnect)) break block12;
                        if (((DidDisconnect)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((DidDisconnect)observers).didDisconnect();
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof DidDisconnect)) continue;
                        if (((DidDisconnect)observer).isPreemptive() == preemptive) {
                            try {
                                ((DidDisconnect)observer).didDisconnect();
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.downlinkDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchDidClose(boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        SwimContext.setLink((Link)this);
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof DidClose)) break block12;
                        if (((DidClose)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((DidClose)observers).didClose();
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof DidClose)) continue;
                        if (((DidClose)observer).isPreemptive() == preemptive) {
                            try {
                                ((DidClose)observer).didClose();
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.downlinkDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchDidFail(Throwable cause, boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        SwimContext.setLink((Link)this);
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof DidFail)) break block12;
                        if (((DidFail)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((DidFail)observers).didFail(cause);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof DidFail)) continue;
                        if (((DidFail)observer).isPreemptive() == preemptive) {
                            try {
                                ((DidFail)observer).didFail(cause);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.downlinkDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    public void downlinkWillReceive(EventMessage message) {
    }

    public void downlinkDidReceive(EventMessage message) {
    }

    public void downlinkWillCommand(CommandMessage message) {
    }

    public void downlinkWillLink(LinkRequest request) {
    }

    public void downlinkDidLink(LinkedResponse response) {
    }

    public void downlinkWillSync(SyncRequest request) {
    }

    public void downlinkDidSync(SyncedResponse response) {
    }

    public void downlinkWillUnlink(UnlinkRequest request) {
    }

    public void downlinkDidUnlink(UnlinkedResponse response) {
    }

    public void downlinkDidConnect() {
    }

    public void downlinkDidDisconnect() {
    }

    public void downlinkDidClose() {
    }

    public void downlinkDidFail(Throwable error) {
    }

    public abstract DownlinkModel<?> createDownlinkModel();

    public abstract DownlinkView open();

    public void command(float prio, Value body) {
        this.downlinkModel().command(prio, body);
    }

    public void command(Value body) {
        this.downlinkModel().command(body);
    }

    public void close() {
        this.downlinkModel().removeDownlink(this);
    }

    public void trace(Object message) {
        DownlinkModel<?> model = this.downlinkModel();
        if (model != null) {
            model.trace(message);
        }
    }

    public void debug(Object message) {
        DownlinkModel<?> model = this.downlinkModel();
        if (model != null) {
            model.debug(message);
        }
    }

    public void info(Object message) {
        DownlinkModel<?> model = this.downlinkModel();
        if (model != null) {
            model.info(message);
        }
    }

    public void warn(Object message) {
        DownlinkModel<?> model = this.downlinkModel();
        if (model != null) {
            model.warn(message);
        }
    }

    public void error(Object message) {
        DownlinkModel<?> model = this.downlinkModel();
        if (model != null) {
            model.error(message);
        }
    }
}

