/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.downlink;

import swim.runtime.downlink.DownlinkRelay;
import swim.runtime.downlink.MapDownlinkModel;
import swim.runtime.downlink.MapDownlinkView;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;
import swim.warp.EventMessage;

final class MapDownlinkRelayRemove
extends DownlinkRelay<MapDownlinkModel, MapDownlinkView<?, ?>> {
    final EventMessage message;
    Form<Object> keyForm;
    Form<Object> valueForm;
    final Value key;
    Object keyObject;
    Value oldValue;
    Object oldObject;

    MapDownlinkRelayRemove(MapDownlinkModel model, EventMessage message, Value key) {
        super(model, 4);
        this.message = message;
        this.key = key;
    }

    MapDownlinkRelayRemove(MapDownlinkModel model, Value key) {
        super(model, 1, 3);
        this.message = null;
        this.key = key;
    }

    @Override
    void beginPhase(int phase) {
        if (phase == 2) {
            if (((MapDownlinkModel)this.model).isStateful()) {
                this.oldValue = (Value)((MapDownlinkModel)this.model).state.remove((Object)this.key);
            }
            if (this.oldValue == null) {
                this.oldValue = Value.absent();
            }
            if (this.valueForm != null) {
                this.oldObject = this.valueForm.cast((Item)this.oldValue);
                if (this.oldObject == null) {
                    this.oldObject = this.valueForm.unit();
                }
            }
        }
    }

    @Override
    boolean runPhase(MapDownlinkView<?, ?> view, int phase, boolean preemptive) {
        if (phase == 0) {
            if (preemptive) {
                view.downlinkWillReceive(this.message);
            }
            return view.dispatchWillReceive(this.message.body(), preemptive);
        }
        if (phase == 1) {
            Form valueForm;
            view.downlinkWillRemoveValue(this.key);
            Form keyForm = view.keyForm;
            if (this.keyForm != keyForm && keyForm != null) {
                this.keyForm = keyForm;
                this.keyObject = keyForm.cast((Item)this.key);
                if (this.keyObject == null) {
                    this.keyObject = keyForm.unit();
                }
            }
            if (this.valueForm != (valueForm = view.valueForm) && valueForm != null) {
                this.valueForm = valueForm;
                this.oldObject = valueForm.cast((Item)this.oldValue);
                if (this.oldObject == null) {
                    this.oldObject = valueForm.unit();
                }
            }
            if (preemptive) {
                view.downlinkWillRemove(this.keyObject);
            }
            return view.dispatchWillRemove(this.keyObject, preemptive);
        }
        if (phase == 2) {
            Form valueForm;
            view.downlinkDidRemoveValue(this.key, this.oldValue);
            Form keyForm = view.keyForm;
            if (this.keyForm != keyForm && keyForm != null) {
                this.keyForm = keyForm;
                this.keyObject = keyForm.cast((Item)this.key);
                if (this.keyObject == null) {
                    this.keyObject = keyForm.unit();
                }
            }
            if (this.valueForm != (valueForm = view.valueForm) && valueForm != null) {
                this.valueForm = valueForm;
                this.oldObject = valueForm.cast((Item)this.oldValue);
                if (this.oldObject == null) {
                    this.oldObject = valueForm.unit();
                }
            }
            if (preemptive) {
                view.downlinkDidRemove(this.keyObject, this.oldObject);
            }
            return view.dispatchDidRemove(this.keyObject, this.oldObject, preemptive);
        }
        if (phase == 3) {
            if (preemptive) {
                view.downlinkDidReceive(this.message);
            }
            return view.dispatchDidReceive(this.message.body(), preemptive);
        }
        throw new AssertionError();
    }

    @Override
    void done() {
        if (this.message != null) {
            ((MapDownlinkModel)this.model).cueDown();
        } else {
            Record header = Record.create((int)1).slot("key", this.key);
            ((MapDownlinkModel)this.model).pushUp((Value)Record.create((int)1).attr("remove", (Value)header));
        }
    }
}

