/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.downlink;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import swim.api.Link;
import swim.api.SwimContext;
import swim.api.downlink.DownlinkException;
import swim.api.downlink.MapDownlink;
import swim.api.downlink.function.DidLink;
import swim.api.downlink.function.DidReceive;
import swim.api.downlink.function.DidSync;
import swim.api.downlink.function.DidUnlink;
import swim.api.downlink.function.WillCommand;
import swim.api.downlink.function.WillLink;
import swim.api.downlink.function.WillReceive;
import swim.api.downlink.function.WillSync;
import swim.api.downlink.function.WillUnlink;
import swim.api.function.DidClose;
import swim.api.function.DidConnect;
import swim.api.function.DidDisconnect;
import swim.api.function.DidFail;
import swim.collections.HashTrieMap;
import swim.concurrent.Conts;
import swim.concurrent.Stage;
import swim.observable.function.DidClear;
import swim.observable.function.DidDrop;
import swim.observable.function.DidRemoveKey;
import swim.observable.function.DidTake;
import swim.observable.function.DidUpdateKey;
import swim.observable.function.WillClear;
import swim.observable.function.WillDrop;
import swim.observable.function.WillRemoveKey;
import swim.observable.function.WillTake;
import swim.observable.function.WillUpdateKey;
import swim.runtime.CellContext;
import swim.runtime.LinkBinding;
import swim.runtime.downlink.DownlinkView;
import swim.runtime.downlink.MapDownlinkModel;
import swim.streamlet.Inlet;
import swim.streamlet.KeyEffect;
import swim.streamlet.KeyOutlet;
import swim.streamlet.MapInlet;
import swim.streamlet.MapOutlet;
import swim.streamlet.Outlet;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Value;
import swim.structure.collections.ValueCollection;
import swim.structure.collections.ValueCursor;
import swim.structure.collections.ValueEntry;
import swim.structure.collections.ValueMapEntrySet;
import swim.structure.collections.ValueOrderedMap;
import swim.structure.collections.ValueOrderedMapCursor;
import swim.structure.collections.ValueSet;
import swim.uri.Uri;
import swim.util.Cursor;
import swim.util.OrderedMap;
import swim.util.OrderedMapCursor;

public class MapDownlinkView<K, V>
extends DownlinkView
implements MapDownlink<K, V> {
    protected final Form<K> keyForm;
    protected final Form<V> valueForm;
    protected MapDownlinkModel model;
    protected MapOutlet<K, V, ? extends Map<K, V>> input;
    protected HashTrieMap<K, KeyEffect> effects;
    protected HashTrieMap<K, KeyOutlet<K, V>> outlets;
    protected Inlet<? super MapDownlink<K, V>>[] outputs;
    protected int version;
    protected static final int STATEFUL = 4;

    public MapDownlinkView(CellContext cellContext, Stage stage, Uri meshUri, Uri hostUri, Uri nodeUri, Uri laneUri, float prio, float rate, Value body, int flags, Form<K> keyForm, Form<V> valueForm, Object observers) {
        super(cellContext, stage, meshUri, hostUri, nodeUri, laneUri, prio, rate, body, flags, observers);
        this.keyForm = keyForm;
        this.valueForm = valueForm;
        this.input = null;
        this.effects = HashTrieMap.empty();
        this.outlets = HashTrieMap.empty();
        this.outputs = null;
        this.version = -1;
    }

    public MapDownlinkView(CellContext cellContext, Stage stage, Uri meshUri, Uri hostUri, Uri nodeUri, Uri laneUri, float prio, float rate, Value body, Form<K> keyForm, Form<V> valueForm) {
        this(cellContext, stage, meshUri, hostUri, nodeUri, laneUri, prio, rate, body, 7, keyForm, valueForm, null);
    }

    public MapDownlinkModel downlinkModel() {
        return this.model;
    }

    @Override
    public MapDownlinkView<K, V> hostUri(Uri hostUri) {
        return new MapDownlinkView<K, V>(this.cellContext, this.stage, this.meshUri, hostUri, this.nodeUri, this.laneUri, this.prio, this.rate, this.body, this.flags, this.keyForm, this.valueForm, this.observers);
    }

    @Override
    public MapDownlinkView<K, V> hostUri(String hostUri) {
        return this.hostUri(Uri.parse((String)hostUri));
    }

    @Override
    public MapDownlinkView<K, V> nodeUri(Uri nodeUri) {
        return new MapDownlinkView<K, V>(this.cellContext, this.stage, this.meshUri, this.hostUri, nodeUri, this.laneUri, this.prio, this.rate, this.body, this.flags, this.keyForm, this.valueForm, this.observers);
    }

    @Override
    public MapDownlinkView<K, V> nodeUri(String nodeUri) {
        return this.nodeUri(Uri.parse((String)nodeUri));
    }

    @Override
    public MapDownlinkView<K, V> laneUri(Uri laneUri) {
        return new MapDownlinkView<K, V>(this.cellContext, this.stage, this.meshUri, this.hostUri, this.nodeUri, laneUri, this.prio, this.rate, this.body, this.flags, this.keyForm, this.valueForm, this.observers);
    }

    @Override
    public MapDownlinkView<K, V> laneUri(String laneUri) {
        return this.laneUri(Uri.parse((String)laneUri));
    }

    @Override
    public MapDownlinkView<K, V> prio(float prio) {
        return new MapDownlinkView<K, V>(this.cellContext, this.stage, this.meshUri, this.hostUri, this.nodeUri, this.laneUri, prio, this.rate, this.body, this.flags, this.keyForm, this.valueForm, this.observers);
    }

    @Override
    public MapDownlinkView<K, V> rate(float rate) {
        return new MapDownlinkView<K, V>(this.cellContext, this.stage, this.meshUri, this.hostUri, this.nodeUri, this.laneUri, this.prio, rate, this.body, this.flags, this.keyForm, this.valueForm, this.observers);
    }

    @Override
    public MapDownlinkView<K, V> body(Value body) {
        return new MapDownlinkView<K, V>(this.cellContext, this.stage, this.meshUri, this.hostUri, this.nodeUri, this.laneUri, this.prio, this.rate, body, this.flags, this.keyForm, this.valueForm, this.observers);
    }

    @Override
    public MapDownlinkView<K, V> keepLinked(boolean keepLinked) {
        this.flags = keepLinked ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
        return this;
    }

    @Override
    public MapDownlinkView<K, V> keepSynced(boolean keepSynced) {
        this.flags = keepSynced ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
        return this;
    }

    public final boolean isStateful() {
        return (this.flags & 4) != 0;
    }

    public MapDownlinkView<K, V> isStateful(boolean isStateful) {
        this.flags = isStateful ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
        MapDownlinkModel model = this.model;
        if (model != null) {
            model.isStateful(isStateful);
        }
        return this;
    }

    void didSetStateful(boolean isStateful) {
        this.flags = isStateful ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    public final Form<K> keyForm() {
        return this.keyForm;
    }

    public <K2> MapDownlinkView<K2, V> keyForm(Form<K2> keyForm) {
        return new MapDownlinkView<K2, V>(this.cellContext, this.stage, this.meshUri, this.hostUri, this.nodeUri, this.laneUri, this.prio, this.rate, this.body, this.flags, keyForm, this.valueForm, this.typesafeObservers(this.observers));
    }

    public <K2> MapDownlinkView<K2, V> keyClass(Class<K2> keyClass) {
        return this.keyForm(Form.forClass(keyClass));
    }

    public final Form<V> valueForm() {
        return this.valueForm;
    }

    public <V2> MapDownlinkView<K, V2> valueForm(Form<V2> valueForm) {
        return new MapDownlinkView<K, V2>(this.cellContext, this.stage, this.meshUri, this.hostUri, this.nodeUri, this.laneUri, this.prio, this.rate, this.body, this.flags, this.keyForm, valueForm, this.typesafeObservers(this.observers));
    }

    public <V2> MapDownlinkView<K, V2> valueClass(Class<V2> valueClass) {
        return this.valueForm(Form.forClass(valueClass));
    }

    protected Object typesafeObservers(Object observers) {
        return observers;
    }

    @Override
    public MapDownlinkView<K, V> observe(Object observer) {
        return (MapDownlinkView)super.observe(observer);
    }

    @Override
    public MapDownlinkView<K, V> unobserve(Object observer) {
        return (MapDownlinkView)super.unobserve(observer);
    }

    public MapDownlinkView<K, V> willUpdate(WillUpdateKey<K, V> willUpdate) {
        return this.observe(willUpdate);
    }

    public MapDownlinkView<K, V> didUpdate(DidUpdateKey<K, V> didUpdate) {
        return this.observe(didUpdate);
    }

    public MapDownlinkView<K, V> willRemove(WillRemoveKey<K> willRemove) {
        return this.observe(willRemove);
    }

    public MapDownlinkView<K, V> didRemove(DidRemoveKey<K, V> didRemove) {
        return this.observe(didRemove);
    }

    public MapDownlink<K, V> willDrop(WillDrop willDrop) {
        return this.observe(willDrop);
    }

    public MapDownlink<K, V> didDrop(DidDrop didDrop) {
        return this.observe(didDrop);
    }

    public MapDownlink<K, V> willTake(WillTake willTake) {
        return this.observe(willTake);
    }

    public MapDownlink<K, V> didTake(DidTake didTake) {
        return this.observe(didTake);
    }

    public MapDownlinkView<K, V> willClear(WillClear willClear) {
        return this.observe(willClear);
    }

    public MapDownlinkView<K, V> didClear(DidClear didClear) {
        return this.observe(didClear);
    }

    @Override
    public MapDownlinkView<K, V> willReceive(WillReceive willReceive) {
        return this.observe(willReceive);
    }

    @Override
    public MapDownlinkView<K, V> didReceive(DidReceive didReceive) {
        return this.observe(didReceive);
    }

    @Override
    public MapDownlinkView<K, V> willCommand(WillCommand willCommand) {
        return this.observe(willCommand);
    }

    @Override
    public MapDownlinkView<K, V> willLink(WillLink willLink) {
        return this.observe(willLink);
    }

    @Override
    public MapDownlinkView<K, V> didLink(DidLink didLink) {
        return this.observe(didLink);
    }

    @Override
    public MapDownlinkView<K, V> willSync(WillSync willSync) {
        return this.observe(willSync);
    }

    @Override
    public MapDownlinkView<K, V> didSync(DidSync didSync) {
        return this.observe(didSync);
    }

    @Override
    public MapDownlinkView<K, V> willUnlink(WillUnlink willUnlink) {
        return this.observe(willUnlink);
    }

    @Override
    public MapDownlinkView<K, V> didUnlink(DidUnlink didUnlink) {
        return this.observe(didUnlink);
    }

    @Override
    public MapDownlinkView<K, V> didConnect(DidConnect didConnect) {
        return this.observe(didConnect);
    }

    @Override
    public MapDownlinkView<K, V> didDisconnect(DidDisconnect didDisconnect) {
        return this.observe(didDisconnect);
    }

    @Override
    public MapDownlinkView<K, V> didClose(DidClose didClose) {
        return this.observe(didClose);
    }

    @Override
    public MapDownlinkView<K, V> didFail(DidFail didFail) {
        return this.observe(didFail);
    }

    public Value downlinkWillUpdateValue(Value key, Value newValue) {
        return newValue;
    }

    public void downlinkDidUpdateValue(Value key, Value newValue, Value oldValue) {
    }

    public V downlinkWillUpdate(K key, V newValue) {
        return newValue;
    }

    public void downlinkDidUpdate(K key, V newValue, V oldValue) {
        this.invalidateInputKey(key, KeyEffect.UPDATE);
        this.reconcileInput(0);
    }

    public void downlinkWillRemoveValue(Value key) {
    }

    public void downlinkDidRemoveValue(Value key, Value oldValue) {
    }

    public void downlinkWillRemove(K key) {
    }

    public void downlinkDidRemove(K key, V oldValue) {
        this.invalidateInputKey(key, KeyEffect.REMOVE);
        this.reconcileInput(0);
    }

    public void downlinkWillDrop(int lower) {
    }

    public void downlinkDidDrop(int lower) {
    }

    public void downlinkWillTake(int upper) {
    }

    public void downlinkDidTake(int upper) {
    }

    public void downlinkWillClear() {
    }

    public void downlinkDidClear() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map.Entry<Boolean, V> dispatchWillUpdate(K key, V newValue, boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        SwimContext.setLink((Link)this);
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof WillUpdateKey)) break block12;
                        if (((WillUpdateKey)observers).isPreemptive() != preemptive) break block13;
                        try {
                            newValue = ((WillUpdateKey)observers).willUpdate(key, newValue);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof WillUpdateKey)) continue;
                        if (((WillUpdateKey)observer).isPreemptive() == preemptive) {
                            try {
                                newValue = ((WillUpdateKey)observer).willUpdate(key, newValue);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.downlinkDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            AbstractMap.SimpleImmutableEntry<Boolean, V> simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<Boolean, V>(complete, newValue);
            return simpleImmutableEntry;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchDidUpdate(K key, V newValue, V oldValue, boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        SwimContext.setLink((Link)this);
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof DidUpdateKey)) break block12;
                        if (((DidUpdateKey)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((DidUpdateKey)observers).didUpdate(key, newValue, oldValue);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof DidUpdateKey)) continue;
                        if (((DidUpdateKey)observer).isPreemptive() == preemptive) {
                            try {
                                ((DidUpdateKey)observer).didUpdate(key, newValue, oldValue);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.downlinkDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchWillRemove(K key, boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        SwimContext.setLink((Link)this);
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof WillRemoveKey)) break block12;
                        if (((WillRemoveKey)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((WillRemoveKey)observers).willRemove(key);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof WillRemoveKey)) continue;
                        if (((WillRemoveKey)observer).isPreemptive() == preemptive) {
                            try {
                                ((WillRemoveKey)observer).willRemove(key);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.downlinkDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchDidRemove(K key, V oldValue, boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        SwimContext.setLink((Link)this);
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof DidRemoveKey)) break block12;
                        if (((DidRemoveKey)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((DidRemoveKey)observers).didRemove(key, oldValue);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof DidRemoveKey)) continue;
                        if (((DidRemoveKey)observer).isPreemptive() == preemptive) {
                            try {
                                ((DidRemoveKey)observer).didRemove(key, oldValue);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.downlinkDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchWillDrop(int lower, boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        SwimContext.setLink((Link)this);
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof WillDrop)) break block12;
                        if (((WillDrop)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((WillDrop)observers).willDrop(lower);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof WillDrop)) continue;
                        if (((WillDrop)observer).isPreemptive() == preemptive) {
                            try {
                                ((WillDrop)observer).willDrop(lower);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.downlinkDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchDidDrop(int lower, boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        SwimContext.setLink((Link)this);
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof DidDrop)) break block12;
                        if (((DidDrop)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((DidDrop)observers).didDrop(lower);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof DidDrop)) continue;
                        if (((DidDrop)observer).isPreemptive() == preemptive) {
                            try {
                                ((DidDrop)observer).didDrop(lower);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.downlinkDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchWillTake(int upper, boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        SwimContext.setLink((Link)this);
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof WillTake)) break block12;
                        if (((WillTake)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((WillTake)observers).willTake(upper);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof WillTake)) continue;
                        if (((WillTake)observer).isPreemptive() == preemptive) {
                            try {
                                ((WillTake)observer).willTake(upper);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.downlinkDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchDidTake(int upper, boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        SwimContext.setLink((Link)this);
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof DidTake)) break block12;
                        if (((DidTake)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((DidTake)observers).didTake(upper);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof DidTake)) continue;
                        if (((DidTake)observer).isPreemptive() == preemptive) {
                            try {
                                ((DidTake)observer).didTake(upper);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.downlinkDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchWillClear(boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        SwimContext.setLink((Link)this);
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof WillClear)) break block12;
                        if (((WillClear)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((WillClear)observers).willClear();
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof WillClear)) continue;
                        if (((WillClear)observer).isPreemptive() == preemptive) {
                            try {
                                ((WillClear)observer).willClear();
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.downlinkDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchDidClear(boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        SwimContext.setLink((Link)this);
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof DidClear)) break block12;
                        if (((DidClear)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((DidClear)observers).didClear();
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof DidClear)) continue;
                        if (((DidClear)observer).isPreemptive() == preemptive) {
                            try {
                                ((DidClear)observer).didClear();
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.downlinkDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    public MapDownlinkModel createDownlinkModel() {
        return new MapDownlinkModel(this.meshUri, this.hostUri, this.nodeUri, this.laneUri, this.prio, this.rate, this.body);
    }

    @Override
    public MapDownlinkView<K, V> open() {
        if (this.model == null) {
            LinkBinding linkBinding = this.cellContext.bindDownlink(this);
            if (linkBinding instanceof MapDownlinkModel) {
                this.model = (MapDownlinkModel)linkBinding;
                this.model.addDownlink(this);
            } else {
                throw new DownlinkException("downlink type mismatch");
            }
        }
        return this;
    }

    public boolean isEmpty() {
        return this.model.isEmpty();
    }

    public int size() {
        return this.model.size();
    }

    public boolean containsKey(Object keyObject) {
        Class keyType = this.keyForm.type();
        if (keyType == null || keyType.isInstance(keyObject)) {
            Value key = this.keyForm.mold(keyObject).toValue();
            return this.model.containsKey(key);
        }
        return false;
    }

    public boolean containsValue(Object valueObject) {
        Class valueType = this.valueForm.type();
        if (valueType == null || valueType.isInstance(valueObject)) {
            Value value = this.valueForm.mold(valueObject).toValue();
            return this.model.containsValue(value);
        }
        return false;
    }

    public int indexOf(Object keyObject) {
        Class keyType = this.keyForm.type();
        if (keyType == null || keyType.isInstance(keyObject)) {
            Value key = this.keyForm.mold(keyObject).toValue();
            return this.model.indexOf(key);
        }
        throw new IllegalArgumentException(keyObject.toString());
    }

    public V get(Object keyObject) {
        Value key;
        Value value;
        Object valueObject;
        Class keyType = this.keyForm.type();
        if ((keyType == null || keyType.isInstance(keyObject)) && (valueObject = this.valueForm.cast((Item)(value = this.model.get(key = this.keyForm.mold(keyObject).toValue())))) != null) {
            return (V)valueObject;
        }
        return (V)this.valueForm.unit();
    }

    public Map.Entry<K, V> getEntry(Object keyObject) {
        Value key;
        Map.Entry<Value, Value> entry;
        Class keyType = this.keyForm.type();
        if ((keyType == null || keyType.isInstance(keyObject)) && (entry = this.model.getEntry(key = this.keyForm.mold(keyObject).toValue())) != null) {
            return new ValueEntry(entry, this.keyForm, this.valueForm);
        }
        return null;
    }

    public Map.Entry<K, V> getIndex(int index) {
        Map.Entry<Value, Value> entry = this.model.getIndex(index);
        if (entry != null) {
            return new ValueEntry(entry, this.keyForm, this.valueForm);
        }
        return null;
    }

    public Map.Entry<K, V> firstEntry() {
        Map.Entry<Value, Value> entry = this.model.firstEntry();
        if (entry != null) {
            return new ValueEntry(entry, this.keyForm, this.valueForm);
        }
        return null;
    }

    public K firstKey() {
        Value key = this.model.firstKey();
        Object keyObject = this.keyForm.cast((Item)key);
        if (keyObject != null) {
            return (K)keyObject;
        }
        return (K)this.keyForm.unit();
    }

    public V firstValue() {
        Value value = this.model.firstValue();
        Object object = this.valueForm.cast((Item)value);
        if (object != null) {
            return (V)object;
        }
        return (V)this.valueForm.unit();
    }

    public Map.Entry<K, V> lastEntry() {
        Map.Entry<Value, Value> entry = this.model.lastEntry();
        if (entry != null) {
            return new ValueEntry(entry, this.keyForm, this.valueForm);
        }
        return null;
    }

    public K lastKey() {
        Value key = this.model.lastKey();
        Object keyObject = this.keyForm.cast((Item)key);
        if (keyObject != null) {
            return (K)keyObject;
        }
        return (K)this.keyForm.unit();
    }

    public V lastValue() {
        Value value = this.model.lastValue();
        Object object = this.valueForm.cast((Item)value);
        if (object != null) {
            return (V)object;
        }
        return (V)this.valueForm.unit();
    }

    public Map.Entry<K, V> nextEntry(Object keyObject) {
        Value key;
        Map.Entry<Value, Value> entry;
        Class keyType = this.keyForm.type();
        if ((keyType == null || keyType.isInstance(keyObject)) && (entry = this.model.nextEntry(key = this.keyForm.mold(keyObject).toValue())) != null) {
            return new ValueEntry(entry, this.keyForm, this.valueForm);
        }
        return null;
    }

    public K nextKey(Object keyObject) {
        Class keyType = this.keyForm.type();
        if (keyType == null || keyType.isInstance(keyObject)) {
            Value key = this.keyForm.mold(keyObject).toValue();
            Value nextKey = this.model.nextKey(key);
            Object nextKeyObject = this.keyForm.cast((Item)nextKey);
            if (nextKeyObject != null) {
                return (K)nextKeyObject;
            }
            return (K)this.keyForm.unit();
        }
        return null;
    }

    public V nextValue(Object keyObject) {
        Class keyType = this.keyForm.type();
        if (keyType == null || keyType.isInstance(keyObject)) {
            Value key = this.keyForm.mold(keyObject).toValue();
            Value nextValue = this.model.nextValue(key);
            Object nextObject = this.valueForm.cast((Item)nextValue);
            if (nextObject != null) {
                return (V)nextObject;
            }
            return (V)this.valueForm.unit();
        }
        return null;
    }

    public Map.Entry<K, V> previousEntry(Object keyObject) {
        Value key;
        Map.Entry<Value, Value> entry;
        Class keyType = this.keyForm.type();
        if ((keyType == null || keyType.isInstance(keyObject)) && (entry = this.model.previousEntry(key = this.keyForm.mold(keyObject).toValue())) != null) {
            return new ValueEntry(entry, this.keyForm, this.valueForm);
        }
        return null;
    }

    public K previousKey(Object keyObject) {
        Class keyType = this.keyForm.type();
        if (keyType == null || keyType.isInstance(keyObject)) {
            Value key = this.keyForm.mold(keyObject).toValue();
            Value previousKey = this.model.previousKey(key);
            Object previousKeyObject = this.keyForm.cast((Item)previousKey);
            if (previousKeyObject != null) {
                return (K)previousKeyObject;
            }
            return (K)this.keyForm.unit();
        }
        return null;
    }

    public V previousValue(Object keyObject) {
        Class keyType = this.keyForm.type();
        if (keyType == null || keyType.isInstance(keyObject)) {
            Value key = this.keyForm.mold(keyObject).toValue();
            Value previousValue = this.model.previousValue(key);
            Object previousObject = this.valueForm.cast((Item)previousValue);
            if (previousObject != null) {
                return (V)previousObject;
            }
            return (V)this.valueForm.unit();
        }
        return null;
    }

    public V put(K key, V value) {
        return this.model.put(this, key, value);
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.model.put(this, entry.getKey(), entry.getValue());
        }
    }

    public V remove(Object key) {
        return this.model.remove(this, key);
    }

    public void drop(int lower) {
        this.model.drop(this, lower);
    }

    public void take(int upper) {
        this.model.take(this, upper);
    }

    public void clear() {
        this.model.clear(this);
    }

    public OrderedMap<K, V> headMap(K toKeyObject) {
        if (this.keyForm != Form.forValue() || this.valueForm != Form.forValue()) {
            Value toKey = this.keyForm.mold(toKeyObject).toValue();
            return new ValueOrderedMap(this.model.headMap(toKey), this.keyForm, this.valueForm);
        }
        return this.model.headMap((Value)toKeyObject);
    }

    public OrderedMap<K, V> tailMap(K fromKeyObject) {
        if (this.keyForm != Form.forValue() || this.valueForm != Form.forValue()) {
            Value fromKey = this.keyForm.mold(fromKeyObject).toValue();
            return new ValueOrderedMap(this.model.tailMap(fromKey), this.keyForm, this.valueForm);
        }
        return this.model.tailMap((Value)fromKeyObject);
    }

    public OrderedMap<K, V> subMap(K fromKeyObject, K toKeyObject) {
        if (this.keyForm != Form.forValue() || this.valueForm != Form.forValue()) {
            Value fromKey = this.keyForm.mold(fromKeyObject).toValue();
            Value toKey = this.keyForm.mold(toKeyObject).toValue();
            return new ValueOrderedMap(this.model.subMap(fromKey, toKey), this.keyForm, this.valueForm);
        }
        return this.model.subMap((Value)fromKeyObject, (Value)toKeyObject);
    }

    public Set<Map.Entry<K, V>> entrySet() {
        if (this.keyForm != Form.forValue() || this.valueForm != Form.forValue()) {
            return new ValueMapEntrySet(this.model.state, this.keyForm, this.valueForm);
        }
        return this.model.entrySet();
    }

    public Set<K> keySet() {
        if (this.keyForm != Form.forValue()) {
            return new ValueSet(this.model.keySet(), this.keyForm);
        }
        return this.model.keySet();
    }

    public Collection<V> values() {
        if (this.valueForm != Form.forValue()) {
            return new ValueCollection(this.model.values(), this.valueForm);
        }
        return this.model.values();
    }

    public OrderedMapCursor<K, V> iterator() {
        if (this.keyForm != Form.forValue() || this.valueForm != Form.forValue()) {
            return new ValueOrderedMapCursor(this.model.iterator(), this.keyForm, this.valueForm);
        }
        return this.model.iterator();
    }

    public Cursor<K> keyIterator() {
        if (this.keyForm != Form.forValue()) {
            return new ValueCursor(this.model.keyIterator(), this.keyForm);
        }
        return this.model.keyIterator();
    }

    public Cursor<V> valueIterator() {
        if (this.valueForm != Form.forValue()) {
            return new ValueCursor(this.model.valueIterator(), this.valueForm);
        }
        return this.model.valueIterator();
    }

    public Comparator<? super K> comparator() {
        return null;
    }

    public MapDownlink<K, V> get() {
        return this;
    }

    public MapOutlet<K, V, ? extends Map<K, V>> input() {
        return this.input;
    }

    public void bindInput(Outlet<? extends Map<K, V>> input) {
        if (!(input instanceof MapOutlet)) {
            throw new IllegalArgumentException(input.toString());
        }
        this.bindInput((MapOutlet)input);
    }

    public void bindInput(MapOutlet<K, V, ? extends Map<K, V>> input) {
        if (this.input != null) {
            this.input.unbindOutput((Inlet)this);
        }
        this.input = input;
        if (this.input != null) {
            this.input.bindOutput((Inlet)this);
        }
    }

    public void unbindInput() {
        if (this.input != null) {
            this.input.unbindOutput((Inlet)this);
        }
        this.input = null;
    }

    public void disconnectInputs() {
        MapOutlet<K, V, ? extends Map<K, V>> input = this.input;
        if (input != null) {
            input.unbindOutput((Inlet)this);
            this.input = null;
            input.disconnectInputs();
        }
    }

    public Outlet<V> outlet(K key) {
        KeyOutlet outlet = (KeyOutlet)this.outlets.get(key);
        if (outlet == null) {
            outlet = new KeyOutlet((MapOutlet)this, key);
            this.outlets = this.outlets.updated(key, (Object)outlet);
        }
        return outlet;
    }

    public Iterator<Inlet<? super MapDownlink<K, V>>> outputIterator() {
        return this.outputs != null ? Cursor.array((Object[])this.outputs) : Cursor.empty();
    }

    public void bindOutput(Inlet<? super MapDownlink<K, V>> output) {
        Inlet<? super MapDownlink<K, V>>[] oldOutputs = this.outputs;
        int n = oldOutputs != null ? oldOutputs.length : 0;
        Inlet[] newOutputs = new Inlet[n + 1];
        if (n > 0) {
            System.arraycopy(oldOutputs, 0, newOutputs, 0, n);
        }
        newOutputs[n] = output;
        this.outputs = newOutputs;
    }

    public void unbindOutput(Inlet<? super MapDownlink<K, V>> output) {
        Inlet<? super MapDownlink<K, V>>[] oldOutputs = this.outputs;
        int n = oldOutputs != null ? oldOutputs.length : 0;
        for (int i = 0; i < n; ++i) {
            if (oldOutputs[i] != output) continue;
            if (n > 1) {
                Inlet[] newOutputs = new Inlet[n - 1];
                System.arraycopy(oldOutputs, 0, newOutputs, 0, i);
                System.arraycopy(oldOutputs, i + 1, newOutputs, i, n - 1 - i);
                this.outputs = newOutputs;
                break;
            }
            this.outputs = null;
            break;
        }
    }

    public void unbindOutputs() {
        Inlet<? super MapDownlink<K, V>>[] outputs;
        HashTrieMap<K, KeyOutlet<K, V>> outlets = this.outlets;
        if (!outlets.isEmpty()) {
            this.outlets = HashTrieMap.empty();
            Iterator keyOutlets = outlets.valueIterator();
            while (keyOutlets.hasNext()) {
                KeyOutlet keyOutlet = (KeyOutlet)keyOutlets.next();
                keyOutlet.unbindOutputs();
            }
        }
        if ((outputs = this.outputs) != null) {
            this.outputs = null;
            for (Inlet<? super MapDownlink<K, V>> output : outputs) {
                output.unbindInput();
            }
        }
    }

    public void disconnectOutputs() {
        Inlet<? super MapDownlink<K, V>>[] outputs;
        HashTrieMap<K, KeyOutlet<K, V>> outlets = this.outlets;
        if (!outlets.isEmpty()) {
            this.outlets = HashTrieMap.empty();
            Iterator keyOutlets = outlets.valueIterator();
            while (keyOutlets.hasNext()) {
                KeyOutlet keyOutlet = (KeyOutlet)keyOutlets.next();
                keyOutlet.disconnectOutputs();
            }
        }
        if ((outputs = this.outputs) != null) {
            this.outputs = null;
            for (Inlet<? super MapDownlink<K, V>> output : outputs) {
                output.unbindInput();
                output.disconnectOutputs();
            }
        }
    }

    public void invalidateOutputKey(K key, KeyEffect effect) {
        this.invalidateKey(key, effect);
    }

    public void invalidateInputKey(K key, KeyEffect effect) {
        this.invalidateKey(key, effect);
    }

    public void invalidateKey(K key, KeyEffect effect) {
        HashTrieMap<K, KeyEffect> oldEffects = this.effects;
        if (oldEffects.get(key) != effect) {
            this.willInvalidateKey(key, effect);
            this.effects = oldEffects.updated(key, (Object)effect);
            this.version = -1;
            this.onInvalidateKey(key, effect);
            int n = this.outputs != null ? this.outputs.length : 0;
            for (int i = 0; i < n; ++i) {
                Inlet<? super MapDownlink<K, V>> output = this.outputs[i];
                if (output instanceof MapInlet) {
                    ((MapInlet)output).invalidateOutputKey(key, effect);
                    continue;
                }
                output.invalidateOutput();
            }
            KeyOutlet outlet = (KeyOutlet)this.outlets.get(key);
            if (outlet != null) {
                outlet.invalidateInput();
            }
            this.didInvalidateKey(key, effect);
        }
    }

    public void invalidateOutput() {
        this.invalidate();
    }

    public void invalidateInput() {
        this.invalidate();
    }

    public void invalidate() {
        if (this.version >= 0) {
            this.willInvalidate();
            this.version = -1;
            this.onInvalidate();
            int n = this.outputs != null ? this.outputs.length : 0;
            for (int i = 0; i < n; ++i) {
                this.outputs[i].invalidateOutput();
            }
            Iterator outlets = this.outlets.valueIterator();
            while (outlets.hasNext()) {
                ((KeyOutlet)outlets.next()).invalidateInput();
            }
            this.didInvalidate();
        }
    }

    public void reconcileOutputKey(K key, int version) {
        this.reconcileKey(key, version);
    }

    public void reconcileInputKey(K key, int version) {
        this.reconcileKey(key, version);
    }

    public void reconcileKey(K key, int version) {
        HashTrieMap<K, KeyEffect> oldEffects;
        KeyEffect effect;
        if (this.version < 0 && (effect = (KeyEffect)(oldEffects = this.effects).get(key)) != null) {
            int n;
            this.willReconcileKey(key, effect, version);
            this.effects = oldEffects.removed(key);
            if (this.input != null) {
                this.input.reconcileInputKey(key, version);
            }
            this.onReconcileKey(key, effect, version);
            int n2 = n = this.outputs != null ? this.outputs.length : 0;
            for (int i = 0; i < n; ++i) {
                Inlet<? super MapDownlink<K, V>> output = this.outputs[i];
                if (!(output instanceof MapInlet)) continue;
                ((MapInlet)output).reconcileOutputKey(key, version);
            }
            KeyOutlet outlet = (KeyOutlet)this.outlets.get(key);
            if (outlet != null) {
                outlet.reconcileInput(version);
            }
            this.didReconcileKey(key, effect, version);
        }
    }

    public void reconcileOutput(int version) {
        this.reconcile(version);
    }

    public void reconcileInput(int version) {
        this.reconcile(version);
    }

    public void reconcile(int version) {
        if (this.version < 0) {
            int n;
            this.willReconcile(version);
            Iterator keys = this.effects.keyIterator();
            while (keys.hasNext()) {
                this.reconcileKey(keys.next(), version);
            }
            this.version = version;
            this.onReconcile(version);
            int n2 = n = this.outputs != null ? this.outputs.length : 0;
            for (int i = 0; i < n; ++i) {
                this.outputs[i].reconcileOutput(version);
            }
            this.didReconcile(version);
        }
    }

    protected void willInvalidateKey(K key, KeyEffect effect) {
    }

    protected void onInvalidateKey(K key, KeyEffect effect) {
    }

    protected void didInvalidateKey(K key, KeyEffect effect) {
    }

    protected void willInvalidate() {
    }

    protected void onInvalidate() {
    }

    protected void didInvalidate() {
    }

    protected void willUpdate(int version) {
    }

    protected void didUpdate(int version) {
    }

    protected void willReconcileKey(K key, KeyEffect effect, int version) {
    }

    protected void onReconcileKey(K key, KeyEffect effect, int version) {
        if (effect == KeyEffect.UPDATE) {
            if (this.input != null) {
                Object value = this.input.get(key);
                if (value != null) {
                    this.put(key, value);
                } else {
                    this.remove(key);
                }
            }
        } else if (effect == KeyEffect.REMOVE && this.containsKey(key)) {
            this.remove(key);
        }
    }

    protected void didReconcileKey(K key, KeyEffect effect, int version) {
    }

    protected void willReconcile(int version) {
    }

    protected void onReconcile(int version) {
    }

    protected void didReconcile(int version) {
    }
}

