/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import java.util.Map;
import swim.api.Link;
import swim.runtime.lane.JoinValueLaneDownlink;
import swim.runtime.lane.JoinValueLaneModel;
import swim.runtime.lane.JoinValueLaneView;
import swim.runtime.lane.LaneRelay;
import swim.structure.Attr;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Value;
import swim.warp.CommandMessage;

final class JoinValueLaneRelayUpdate
extends LaneRelay<JoinValueLaneModel, JoinValueLaneView<?, ?>> {
    final Link link;
    final CommandMessage message;
    Form<Object> keyForm;
    Form<Object> valueForm;
    final Value key;
    Object keyObject;
    Value oldValue;
    Object oldObject;
    Value newValue;
    Object newObject;

    JoinValueLaneRelayUpdate(JoinValueLaneModel model, Link link, CommandMessage message, Value key, Value newValue) {
        super(model, 4);
        this.link = link;
        this.message = message;
        this.key = key;
        this.newValue = newValue;
    }

    JoinValueLaneRelayUpdate(JoinValueLaneModel model, Link link, Value key, Value newValue) {
        super(model, 1, 3);
        this.link = link;
        this.message = null;
        this.key = key;
        this.newValue = newValue;
    }

    @Override
    void beginPhase(int phase) {
        if (phase == 2) {
            JoinValueLaneDownlink<?> downlink;
            Item head = ((Value)((JoinValueLaneModel)this.model).data.get((Object)this.key)).head();
            Value dataValue = this.newValue;
            if (head instanceof Attr && "downlink".equals(((Attr)head).name())) {
                dataValue = head.concat((Item)dataValue);
            }
            this.oldValue = (Value)((JoinValueLaneModel)this.model).data.put((Object)this.key, (Object)dataValue);
            if ("downlink".equals(this.oldValue.tag())) {
                this.oldValue = this.oldValue.body();
            }
            if (this.valueForm != null) {
                this.oldObject = this.valueForm.cast((Item)this.oldValue);
                if (this.oldObject == null) {
                    this.oldObject = this.valueForm.unit();
                }
            }
            if (this.message != null && (downlink = ((JoinValueLaneModel)this.model).getDownlink(this.key)) != null) {
                downlink.setValue(this.newValue);
            }
        }
    }

    @Override
    boolean runPhase(JoinValueLaneView<?, ?> view, int phase, boolean preemptive) {
        if (phase == 0) {
            if (preemptive) {
                view.laneWillCommand(this.message);
            }
            return view.dispatchWillCommand(this.message.body(), preemptive);
        }
        if (phase == 1) {
            Form valueForm;
            Form keyForm = view.keyForm;
            if (this.keyForm != keyForm && keyForm != null) {
                this.keyForm = keyForm;
                this.keyObject = keyForm.cast((Item)this.key);
                if (this.keyObject == null) {
                    this.keyObject = keyForm.unit();
                }
            }
            if (this.valueForm != (valueForm = view.valueForm) && valueForm != null) {
                this.valueForm = valueForm;
                this.oldObject = valueForm.cast((Item)this.newValue);
                if (this.oldObject == null) {
                    this.oldObject = valueForm.unit();
                }
            }
            if (preemptive) {
                this.newObject = view.laneWillUpdate(this.keyObject, this.oldObject);
            }
            Map.Entry<Boolean, Object> result = view.dispatchWillUpdate(this.link, this.keyObject, this.oldObject, preemptive);
            this.newObject = result.getValue();
            if (this.oldObject != this.newObject) {
                this.oldObject = this.newObject;
                this.newValue = valueForm.mold(this.newObject).toValue();
            }
            return result.getKey();
        }
        if (phase == 2) {
            Form valueForm;
            Form keyForm = view.keyForm;
            if (this.keyForm != keyForm && keyForm != null) {
                this.keyForm = keyForm;
                this.keyObject = keyForm.cast((Item)this.key);
                if (this.keyObject == null) {
                    this.keyObject = keyForm.unit();
                }
            }
            if (this.valueForm != (valueForm = view.valueForm) && valueForm != null) {
                this.valueForm = valueForm;
                this.oldObject = valueForm.cast((Item)this.oldValue);
                if (this.oldObject == null) {
                    this.oldObject = valueForm.unit();
                }
                this.newObject = valueForm.cast((Item)this.newValue);
                if (this.newObject == null) {
                    this.newObject = valueForm.unit();
                }
            }
            if (preemptive) {
                view.laneDidUpdate(this.keyObject, this.newObject, this.oldObject);
            }
            return view.dispatchDidUpdate(this.link, this.keyObject, this.newObject, this.oldObject, preemptive);
        }
        if (phase == 3) {
            if (preemptive) {
                view.laneDidCommand(this.message);
            }
            return view.dispatchDidCommand(this.message.body(), preemptive);
        }
        throw new AssertionError();
    }

    @Override
    void done() {
        ((JoinValueLaneModel)this.model).cueDownKey(this.key);
    }
}

