/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.router;

import swim.api.auth.Identity;
import swim.api.data.DataFactory;
import swim.api.downlink.Downlink;
import swim.api.policy.Policy;
import swim.concurrent.Schedule;
import swim.concurrent.Stage;
import swim.math.Z2Form;
import swim.runtime.HttpBinding;
import swim.runtime.LaneBinding;
import swim.runtime.LinkBinding;
import swim.runtime.NodeBinding;
import swim.runtime.NodeContext;
import swim.runtime.PushRequest;
import swim.runtime.router.HostTable;
import swim.store.ListDataBinding;
import swim.store.MapDataBinding;
import swim.store.SpatialDataBinding;
import swim.store.ValueDataBinding;
import swim.structure.Value;
import swim.uri.Uri;

public class HostTableNode
implements NodeContext {
    protected final HostTable host;
    protected final NodeBinding node;
    protected final Uri nodeUri;

    public HostTableNode(HostTable host, NodeBinding node, Uri nodeUri) {
        this.host = host;
        this.node = node;
        this.nodeUri = nodeUri;
    }

    @Override
    public final Uri meshUri() {
        return this.host.meshUri();
    }

    @Override
    public final Value partKey() {
        return this.host.partKey();
    }

    @Override
    public final Uri hostUri() {
        return this.host.hostUri();
    }

    @Override
    public final Uri nodeUri() {
        return this.nodeUri;
    }

    @Override
    public Value agentKey() {
        return this.node.agentKey();
    }

    @Override
    public final Identity identity() {
        return null;
    }

    @Override
    public Policy policy() {
        return this.host.policy();
    }

    @Override
    public Schedule schedule() {
        return this.host.schedule();
    }

    @Override
    public Stage stage() {
        return this.host.stage();
    }

    @Override
    public DataFactory data() {
        return this.host.data();
    }

    @Override
    public LaneBinding injectLane(Uri laneUri, LaneBinding lane) {
        return this.host.hostContext().injectLane(this.nodeUri, laneUri, lane);
    }

    public ListDataBinding openListData(Value name) {
        return this.host.openListData(name);
    }

    public ListDataBinding injectListData(ListDataBinding dataBinding) {
        return this.host.injectListData(dataBinding);
    }

    public MapDataBinding openMapData(Value name) {
        return this.host.openMapData(name);
    }

    public MapDataBinding injectMapData(MapDataBinding dataBinding) {
        return this.host.injectMapData(dataBinding);
    }

    public <S> SpatialDataBinding<S> openSpatialData(Value name, Z2Form<S> shapeForm) {
        return this.host.openSpatialData(name, shapeForm);
    }

    public <S> SpatialDataBinding<S> injectSpatialData(SpatialDataBinding<S> dataBinding) {
        return this.host.injectSpatialData(dataBinding);
    }

    public ValueDataBinding openValueData(Value name) {
        return this.host.openValueData(name);
    }

    public ValueDataBinding injectValueData(ValueDataBinding dataBinding) {
        return this.host.injectValueData(dataBinding);
    }

    @Override
    public LinkBinding bindDownlink(Downlink downlink) {
        return this.host.bindDownlink(downlink);
    }

    @Override
    public void openDownlink(LinkBinding link) {
        this.host.openDownlink(link);
    }

    @Override
    public void closeDownlink(LinkBinding link) {
    }

    @Override
    public void httpDownlink(HttpBinding http) {
        this.host.httpDownlink(http);
    }

    @Override
    public void pushDown(PushRequest pushRequest) {
        this.host.pushDown(pushRequest);
    }

    public void trace(Object message) {
        this.host.trace(message);
    }

    public void debug(Object message) {
        this.host.debug(message);
    }

    public void info(Object message) {
        this.host.info(message);
    }

    public void warn(Object message) {
        this.host.warn(message);
    }

    public void error(Object message) {
        this.host.error(message);
    }

    @Override
    public void close() {
        this.host.closeNode(this.nodeUri);
    }

    @Override
    public void willOpen() {
    }

    @Override
    public void didOpen() {
    }

    @Override
    public void willLoad() {
    }

    @Override
    public void didLoad() {
    }

    @Override
    public void willStart() {
    }

    @Override
    public void didStart() {
    }

    @Override
    public void willStop() {
    }

    @Override
    public void didStop() {
    }

    @Override
    public void willUnload() {
    }

    @Override
    public void didUnload() {
    }

    @Override
    public void willClose() {
    }
}

