/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.router;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.api.data.DataFactory;
import swim.api.downlink.Downlink;
import swim.api.policy.Policy;
import swim.collections.FingerTrieSeq;
import swim.concurrent.Schedule;
import swim.concurrent.Stage;
import swim.math.Z2Form;
import swim.runtime.AbstractTierBinding;
import swim.runtime.HttpBinding;
import swim.runtime.LinkBinding;
import swim.runtime.MeshBinding;
import swim.runtime.MeshContext;
import swim.runtime.PartBinding;
import swim.runtime.PartContext;
import swim.runtime.PushRequest;
import swim.runtime.TierBinding;
import swim.runtime.TierContext;
import swim.runtime.router.MeshTablePart;
import swim.runtime.uplink.ErrorUplinkModem;
import swim.runtime.uplink.HttpErrorUplinkModem;
import swim.store.DataBinding;
import swim.store.ListDataBinding;
import swim.store.MapDataBinding;
import swim.store.SpatialDataBinding;
import swim.store.ValueDataBinding;
import swim.structure.Record;
import swim.structure.Text;
import swim.structure.Value;
import swim.uri.Uri;

public class MeshTable
extends AbstractTierBinding
implements MeshBinding {
    protected MeshContext meshContext;
    volatile FingerTrieSeq<PartBinding> parts = FingerTrieSeq.empty();
    volatile PartBinding gateway;
    volatile PartBinding ourself;
    static final AtomicReferenceFieldUpdater<MeshTable, FingerTrieSeq<PartBinding>> PARTS = AtomicReferenceFieldUpdater.newUpdater(MeshTable.class, FingerTrieSeq.class, "parts");

    @Override
    public final TierContext tierContext() {
        return this.meshContext;
    }

    @Override
    public final MeshContext meshContext() {
        return this.meshContext;
    }

    @Override
    public void setMeshContext(MeshContext meshContext) {
        this.meshContext = meshContext;
    }

    @Override
    public <T> T unwrapMesh(Class<T> meshClass) {
        if (meshClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return null;
    }

    protected PartContext createPartContext(PartBinding part, Value partKey) {
        return new MeshTablePart(this, part, partKey);
    }

    @Override
    public final Uri meshUri() {
        return this.meshContext.meshUri();
    }

    @Override
    public Policy policy() {
        return this.meshContext.policy();
    }

    @Override
    public Schedule schedule() {
        return this.meshContext.schedule();
    }

    @Override
    public Stage stage() {
        return this.meshContext.stage();
    }

    @Override
    public DataFactory data() {
        return this.meshContext.data();
    }

    @Override
    public PartBinding getGateway() {
        return this.gateway;
    }

    @Override
    public void setGateway(PartBinding gateway) {
        this.gateway = gateway;
    }

    @Override
    public PartBinding getOurself() {
        return this.ourself;
    }

    @Override
    public void setOurself(PartBinding ourself) {
        this.ourself = ourself;
    }

    @Override
    public FingerTrieSeq<PartBinding> getParts() {
        return this.parts;
    }

    boolean isMetaNode(Uri nodeUri) {
        return !this.meshUri().isDefined() && "swim".equals(nodeUri.schemeName());
    }

    @Override
    public PartBinding getPart(Uri nodeUri) {
        if (this.isMetaNode(nodeUri)) {
            return this.ourself;
        }
        FingerTrieSeq<PartBinding> parts = this.parts;
        int n = parts.size();
        for (int i = 0; i < n; ++i) {
            PartBinding part = (PartBinding)parts.get(i);
            if (!part.predicate().test(nodeUri)) continue;
            return part;
        }
        return this.gateway;
    }

    @Override
    public PartBinding getPart(Value partKey) {
        FingerTrieSeq<PartBinding> parts = this.parts;
        int n = parts.size();
        for (int i = 0; i < n; ++i) {
            PartBinding part = (PartBinding)parts.get(i);
            if (!partKey.equals((Object)part.partKey())) continue;
            return part;
        }
        return null;
    }

    @Override
    public PartBinding openPart(Uri nodeUri) {
        FingerTrieSeq newParts;
        FingerTrieSeq oldParts;
        TierBinding partBinding = null;
        Text partKey = Text.from((String)"swim-app");
        do {
            oldParts = this.parts;
            PartBinding part = null;
            if (this.isMetaNode(nodeUri)) {
                part = this.ourself;
            } else {
                int n = oldParts.size();
                for (int i = 0; i < n; ++i) {
                    PartBinding oldPart = (PartBinding)oldParts.get(i);
                    if (!oldPart.predicate().test(nodeUri)) continue;
                    part = oldPart;
                    break;
                }
            }
            if (part != null) {
                if (partBinding != null) {
                    partBinding.close();
                }
                partBinding = part;
                newParts = oldParts;
                break;
            }
            if (partBinding == null) {
                partKey = this.isMetaNode(nodeUri) ? Text.from((String)"swim") : Text.from((String)"swim-app");
                partBinding = this.meshContext.createPart((Value)partKey);
                if (partBinding != null) {
                    partBinding = this.meshContext.injectPart((Value)partKey, (PartBinding)partBinding);
                    PartContext partContext = this.createPartContext((PartBinding)partBinding, (Value)partKey);
                    partBinding.setPartContext(partContext);
                    newParts = oldParts.appended((Object)partBinding);
                    continue;
                }
                newParts = oldParts;
                break;
            }
            newParts = oldParts.appended((Object)partBinding);
        } while (oldParts != newParts && !PARTS.compareAndSet(this, (FingerTrieSeq<PartBinding>)oldParts, (FingerTrieSeq<PartBinding>)newParts));
        if (oldParts != newParts) {
            if (Value.extant().equals((Object)partKey)) {
                this.gateway = partBinding;
            } else if (this.isMetaNode(nodeUri)) {
                this.ourself = partBinding;
            }
            this.activate(partBinding);
        }
        return partBinding;
    }

    @Override
    public PartBinding openGateway() {
        FingerTrieSeq newParts;
        FingerTrieSeq oldParts;
        TierBinding partBinding = null;
        do {
            oldParts = this.parts;
            PartBinding part = this.gateway;
            if (part != null) {
                if (partBinding != null) {
                    partBinding.close();
                }
                partBinding = part;
                newParts = oldParts;
                break;
            }
            if (partBinding == null) {
                Text partKey = Text.from((String)"swim-app");
                partBinding = this.meshContext.createPart((Value)partKey);
                if (partBinding != null) {
                    partBinding = this.meshContext.injectPart((Value)partKey, (PartBinding)partBinding);
                    PartContext partContext = this.createPartContext((PartBinding)partBinding, (Value)partKey);
                    partBinding.setPartContext(partContext);
                    newParts = oldParts.appended((Object)partBinding);
                    continue;
                }
                newParts = oldParts;
                break;
            }
            newParts = oldParts.appended((Object)partBinding);
        } while (oldParts != newParts && !PARTS.compareAndSet(this, (FingerTrieSeq<PartBinding>)oldParts, (FingerTrieSeq<PartBinding>)newParts));
        if (oldParts != newParts) {
            this.gateway = partBinding;
            this.activate(partBinding);
        }
        return partBinding;
    }

    @Override
    public PartBinding addPart(Value partKey, PartBinding part) {
        FingerTrieSeq newParts;
        FingerTrieSeq<PartBinding> oldParts;
        PartBinding partBinding = null;
        do {
            PartBinding oldPart;
            oldParts = this.parts;
            int n = oldParts.size();
            for (int i = 0; i < n && !partKey.equals((Object)(oldPart = (PartBinding)oldParts.get(i)).partKey()); ++i) {
            }
            if (partBinding != null) continue;
            partBinding = this.meshContext.injectPart(partKey, part);
            PartContext partContext = this.createPartContext(partBinding, partKey);
            partBinding.setPartContext(partContext);
        } while (oldParts != (newParts = oldParts.appended(partBinding)) && !PARTS.compareAndSet(this, oldParts, (FingerTrieSeq<PartBinding>)newParts));
        if (partBinding != null) {
            this.activate(partBinding);
        }
        return partBinding;
    }

    public void closePart(Value partKey) {
        PartBinding partBinding;
        FingerTrieSeq newParts;
        FingerTrieSeq oldParts;
        block0: do {
            newParts = oldParts = this.parts;
            partBinding = null;
            int n = oldParts.size();
            for (int i = 0; i < n; ++i) {
                PartBinding part = (PartBinding)oldParts.get(i);
                if (!partKey.equals((Object)part.partKey())) continue;
                partBinding = part;
                newParts = oldParts.removed(i);
                continue block0;
            }
        } while (oldParts != newParts && !PARTS.compareAndSet(this, oldParts, newParts));
        if (partBinding != null) {
            if (this.gateway == partBinding) {
                this.gateway = null;
            } else if (this.ourself == partBinding) {
                this.ourself = null;
            }
            partBinding.didClose();
        }
    }

    public Iterator<DataBinding> dataBindings() {
        return Collections.emptyIterator();
    }

    public void closeData(Value name) {
    }

    public ListDataBinding openListData(Value name) {
        return this.meshContext.openListData(name);
    }

    public ListDataBinding injectListData(ListDataBinding dataBinding) {
        return this.meshContext.injectListData(dataBinding);
    }

    public MapDataBinding openMapData(Value name) {
        return this.meshContext.openMapData(name);
    }

    public MapDataBinding injectMapData(MapDataBinding dataBinding) {
        return this.meshContext.injectMapData(dataBinding);
    }

    public <S> SpatialDataBinding<S> openSpatialData(Value name, Z2Form<S> shapeForm) {
        return this.meshContext.openSpatialData(name, shapeForm);
    }

    public <S> SpatialDataBinding<S> injectSpatialData(SpatialDataBinding<S> dataBinding) {
        return this.meshContext.injectSpatialData(dataBinding);
    }

    public ValueDataBinding openValueData(Value name) {
        return this.meshContext.openValueData(name);
    }

    public ValueDataBinding injectValueData(ValueDataBinding dataBinding) {
        return this.meshContext.injectValueData(dataBinding);
    }

    @Override
    public LinkBinding bindDownlink(Downlink downlink) {
        return this.meshContext.bindDownlink(downlink);
    }

    @Override
    public void openDownlink(LinkBinding link) {
        this.meshContext.openDownlink(link);
    }

    @Override
    public void closeDownlink(LinkBinding link) {
    }

    @Override
    public void openUplink(LinkBinding link) {
        PartBinding partBinding = this.openPart(link.nodeUri());
        if (partBinding != null) {
            partBinding.openUplink(link);
        } else {
            ErrorUplinkModem linkContext = new ErrorUplinkModem(link, (Value)Record.of().attr("noPart"));
            link.setLinkContext(linkContext);
            linkContext.cueDown();
        }
    }

    @Override
    public void httpDownlink(HttpBinding http) {
    }

    @Override
    public void httpUplink(HttpBinding http) {
        PartBinding partBinding = this.openPart(http.nodeUri());
        if (partBinding != null) {
            partBinding.httpUplink(http);
        } else {
            HttpErrorUplinkModem httpContext = new HttpErrorUplinkModem(http);
            http.setHttpContext(httpContext);
        }
    }

    @Override
    public void pushDown(PushRequest pushRequest) {
        this.meshContext.pushDown(pushRequest);
    }

    @Override
    public void pushUp(PushRequest pushRequest) {
        PartBinding partBinding = this.openPart(pushRequest.nodeUri());
        if (partBinding != null) {
            partBinding.pushUp(pushRequest);
        } else {
            pushRequest.didDecline();
        }
    }

    public void trace(Object message) {
        this.meshContext.trace(message);
    }

    public void debug(Object message) {
        this.meshContext.debug(message);
    }

    public void info(Object message) {
        this.meshContext.info(message);
    }

    public void warn(Object message) {
        this.meshContext.warn(message);
    }

    public void error(Object message) {
        this.meshContext.error(message);
    }

    @Override
    protected void willOpen() {
        super.willOpen();
        Iterator partsIterator = this.parts.iterator();
        while (partsIterator.hasNext()) {
            ((PartBinding)partsIterator.next()).open();
        }
    }

    @Override
    protected void willLoad() {
        super.willLoad();
        Iterator partsIterator = this.parts.iterator();
        while (partsIterator.hasNext()) {
            ((PartBinding)partsIterator.next()).load();
        }
    }

    @Override
    protected void willStart() {
        super.willStart();
        Iterator partsIterator = this.parts.iterator();
        while (partsIterator.hasNext()) {
            ((PartBinding)partsIterator.next()).start();
        }
    }

    @Override
    protected void willStop() {
        super.willStop();
        Iterator partsIterator = this.parts.iterator();
        while (partsIterator.hasNext()) {
            ((PartBinding)partsIterator.next()).stop();
        }
    }

    @Override
    protected void willUnload() {
        super.willUnload();
        Iterator partsIterator = this.parts.iterator();
        while (partsIterator.hasNext()) {
            ((PartBinding)partsIterator.next()).unload();
        }
    }

    @Override
    protected void willClose() {
        super.willClose();
        Iterator partsIterator = this.parts.iterator();
        while (partsIterator.hasNext()) {
            ((PartBinding)partsIterator.next()).close();
        }
    }

    @Override
    public void didClose() {
    }

    @Override
    public void didFail(Throwable error) {
        error.printStackTrace();
    }
}

