/*
 * Decompiled with CFR 0.152.
 */
package swim.io;

import swim.io.SocketSettings;
import swim.io.TcpSettings;
import swim.io.TlsSettings;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;

final class SocketSettingsForm
extends Form<SocketSettings> {
    SocketSettingsForm() {
    }

    public SocketSettings unit() {
        return SocketSettings.standard();
    }

    public Class<?> type() {
        return SocketSettings.class;
    }

    public Item mold(SocketSettings settings) {
        if (settings != null) {
            Record record = Record.create((int)2);
            record.add(TcpSettings.form().mold((Object)settings.tcpSettings));
            record.add(TlsSettings.form().mold((Object)settings.tlsSettings));
            return record;
        }
        return Item.extant();
    }

    public SocketSettings cast(Item item) {
        Value value = item.toValue();
        TcpSettings tcpSettings = null;
        TlsSettings tlsSettings = null;
        for (Item member : value) {
            TlsSettings newTlsSettings;
            TcpSettings newTcpSettings = (TcpSettings)TcpSettings.form().cast(member);
            if (newTcpSettings != null) {
                tcpSettings = newTcpSettings;
            }
            if ((newTlsSettings = (TlsSettings)TlsSettings.form().cast(member)) == null) continue;
            tlsSettings = newTlsSettings;
        }
        if (tcpSettings == null) {
            tcpSettings = TcpSettings.standard();
        }
        if (tlsSettings == null) {
            tlsSettings = TlsSettings.standard();
        }
        return new SocketSettings(tcpSettings, tlsSettings);
    }
}

