/*
 * Decompiled with CFR 0.152.
 */
package swim.structure.collections;

import swim.structure.Form;
import swim.structure.Value;
import swim.util.Cursor;

public class ValueCursor<T>
implements Cursor<T> {
    protected Cursor<Value> inner;
    protected Form<T> valueForm;

    public ValueCursor(Cursor<? extends Value> inner, Form<T> valueForm) {
        this.inner = inner;
        this.valueForm = valueForm;
    }

    public Cursor<Value> inner() {
        return this.inner;
    }

    public Form<T> valueForm() {
        return this.valueForm;
    }

    public <T2> ValueCursor<T2> valueForm(Form<T2> valueForm) {
        return new ValueCursor<T2>(this.inner, valueForm);
    }

    public <T2> ValueCursor<T2> valueClass(Class<T2> valueClass) {
        return this.valueForm(Form.forClass(valueClass));
    }

    public boolean isEmpty() {
        return this.inner.isEmpty();
    }

    public T head() {
        Value value = (Value)this.inner.head();
        T object = this.valueForm.cast(value);
        if (object != null) {
            return object;
        }
        return this.valueForm.unit();
    }

    public void step() {
        this.inner.step();
    }

    public void skip(long count) {
        this.inner.skip(count);
    }

    public boolean hasNext() {
        return this.inner.hasNext();
    }

    public long nextIndexLong() {
        return this.inner.nextIndexLong();
    }

    public int nextIndex() {
        return this.inner.nextIndex();
    }

    public T next() {
        Value value = (Value)this.inner.next();
        T object = this.valueForm.cast(value);
        if (object != null) {
            return object;
        }
        return this.valueForm.unit();
    }

    public boolean hasPrevious() {
        return this.inner.hasPrevious();
    }

    public long previousIndexLong() {
        return this.inner.previousIndexLong();
    }

    public int previousIndex() {
        return this.inner.previousIndex();
    }

    public T previous() {
        Value value = (Value)this.inner.previous();
        T object = this.valueForm.cast(value);
        if (object != null) {
            return object;
        }
        return this.valueForm.unit();
    }

    public void set(T newObject) {
        Value newValue = this.valueForm.mold(newObject).toValue();
        this.inner.set((Object)newValue);
    }

    public void add(T newObject) {
        Value newValue = this.valueForm.mold(newObject).toValue();
        this.inner.add((Object)newValue);
    }

    public void remove() {
        this.inner.remove();
    }

    public void load() throws InterruptedException {
        this.inner.load();
    }
}

