/*
 * Decompiled with CFR 0.152.
 */
package swim.structure.collections;

import java.util.Map;
import swim.structure.Form;
import swim.structure.Value;

public final class ValueEntry<K, V>
implements Map.Entry<K, V> {
    final Map.Entry<Value, Value> inner;
    final Form<K> keyForm;
    final Form<V> valueForm;
    volatile K keyObject;
    volatile V valueObject;

    public ValueEntry(Map.Entry<Value, Value> inner, Form<K> keyForm, Form<V> valueForm) {
        if (inner == null) {
            throw new NullPointerException();
        }
        this.inner = inner;
        this.keyForm = keyForm;
        this.valueForm = valueForm;
    }

    @Override
    public K getKey() {
        K keyObject = this.keyObject;
        if (keyObject == null) {
            keyObject = this.keyForm.cast(this.inner.getKey());
            if (keyObject == null) {
                keyObject = this.keyForm.unit();
            }
            this.keyObject = keyObject;
        }
        return keyObject;
    }

    @Override
    public V getValue() {
        V valueObject = this.valueObject;
        if (valueObject == null) {
            valueObject = this.valueForm.cast(this.inner.getValue());
            if (valueObject == null) {
                valueObject = this.valueForm.unit();
            }
            this.valueObject = valueObject;
        }
        return valueObject;
    }

    @Override
    public V setValue(V newValueObject) {
        Value newValue = this.valueForm.mold(newValueObject).toValue();
        Value oldValue = this.inner.setValue(newValue);
        V oldValueObject = this.valueForm.cast(oldValue);
        if (oldValueObject != null) {
            return oldValueObject;
        }
        return this.valueForm.unit();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Map.Entry) {
            Map.Entry that = (Map.Entry)other;
            K keyObject = this.getKey();
            if (keyObject == null ? that.getKey() != null : !keyObject.equals(that.getKey())) {
                return false;
            }
            V valueObject = this.getValue();
            return !(valueObject == null ? that.getValue() != null : !valueObject.equals(that.getValue()));
        }
        return false;
    }

    @Override
    public int hashCode() {
        K keyObject = this.getKey();
        V valueObject = this.getValue();
        return (keyObject == null ? 0 : keyObject.hashCode()) ^ (valueObject == null ? 0 : valueObject.hashCode());
    }

    public String toString() {
        return "" + this.getKey() + '=' + this.getValue();
    }
}

