/*
 * Decompiled with CFR 0.152.
 */
package swim.structure.func;

import swim.structure.Interpreter;
import swim.structure.Item;
import swim.structure.Num;
import swim.structure.Value;
import swim.structure.func.BridgeFunc;
import swim.structure.func.RateFuncState;
import swim.structure.operator.InvokeOperator;

final class RateFunc
extends BridgeFunc {
    RateFunc() {
    }

    @Override
    public Item invoke(Value args, Interpreter interpreter, InvokeOperator operator) {
        long period;
        double value;
        if (args.length() >= 2) {
            value = args.getItem(0).evaluate(interpreter).doubleValue(Double.NaN);
            period = args.getItem(1).evaluate(interpreter).longValue(1000L);
        } else {
            value = args.evaluate(interpreter).doubleValue(Double.NaN);
            period = 1000L;
        }
        if (!Double.isNaN(value) && operator != null) {
            RateFuncState state = (RateFuncState)operator.state();
            if (state == null) {
                state = new RateFuncState();
                state.v0 = value;
                state.t0 = System.currentTimeMillis();
                operator.setState(state);
            } else {
                long t1 = System.currentTimeMillis();
                long dt = t1 - state.t0;
                if (dt > period && t1 > state.t0 || dt > 2L * period) {
                    double dv = value - state.v0;
                    state.v0 = value;
                    state.t0 = t1;
                    state.dv = dv;
                    state.dt = dt;
                }
                operator.setState(state);
                if (state.dt != 0L) {
                    double rate = (double)period * state.dv / (double)state.dt;
                    return Num.from(rate);
                }
            }
        }
        return Item.absent();
    }

    @Override
    public Item expand(Value args, Interpreter interpreter, InvokeOperator operator) {
        args = args.evaluate(interpreter).toValue();
        return this.invoke(args, interpreter, operator);
    }
}

