/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Encoder;
import swim.codec.EncoderException;
import swim.codec.OutputBuffer;
import swim.mqtt.MqttConnAck;
import swim.mqtt.MqttEncoder;
import swim.mqtt.MqttException;

final class MqttConnAckEncoder
extends Encoder<Object, MqttConnAck> {
    final MqttEncoder mqtt;
    final MqttConnAck packet;
    final int length;
    final int remaining;
    final int step;

    MqttConnAckEncoder(MqttEncoder mqtt, MqttConnAck packet, int length, int remaining, int step) {
        this.mqtt = mqtt;
        this.packet = packet;
        this.length = length;
        this.remaining = remaining;
        this.step = step;
    }

    MqttConnAckEncoder(MqttEncoder mqtt, MqttConnAck packet) {
        this(mqtt, packet, 0, 0, 1);
    }

    public Encoder<Object, MqttConnAck> pull(OutputBuffer<?> output) {
        return MqttConnAckEncoder.encode(output, this.mqtt, this.packet, this.length, this.remaining, this.step);
    }

    static Encoder<Object, MqttConnAck> encode(OutputBuffer<?> output, MqttEncoder mqtt, MqttConnAck packet, int length, int remaining, int step) {
        if (step == 1 && output.isCont()) {
            remaining = length = packet.bodySize(mqtt);
            output = output.write(packet.packetType() << 4 | packet.packetFlags & 0xF);
            step = 2;
        }
        while (step >= 2 && step <= 5 && output.isCont()) {
            int b = length & 0x7F;
            if ((length >>>= 7) > 0) {
                b |= 0x80;
            }
            output = output.write(b);
            if (length == 0) {
                step = 6;
                break;
            }
            if (step < 5) {
                ++step;
                continue;
            }
            return MqttConnAckEncoder.error((Throwable)new MqttException("packet length too long: " + remaining));
        }
        if (step == 6 && remaining > 0 && output.isCont()) {
            output = output.write(packet.connectFlags);
            --remaining;
            step = 7;
        }
        if (step == 7 && remaining > 0 && output.isCont()) {
            output = output.write(packet.connectCode);
            --remaining;
            step = 8;
        }
        if (step == 8 && remaining == 0) {
            return MqttConnAckEncoder.done((Object)packet);
        }
        if (remaining < 0) {
            return MqttConnAckEncoder.error((Throwable)new MqttException("packet length too short"));
        }
        if (output.isDone()) {
            return MqttConnAckEncoder.error((Throwable)new EncoderException("truncated"));
        }
        if (output.isError()) {
            return MqttConnAckEncoder.error((Throwable)output.trap());
        }
        return new MqttConnAckEncoder(mqtt, packet, length, remaining, step);
    }

    static Encoder<Object, MqttConnAck> encode(OutputBuffer<?> output, MqttEncoder mqtt, MqttConnAck packet) {
        return MqttConnAckEncoder.encode(output, mqtt, packet, 0, 0, 1);
    }
}

