/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Debug;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.collections.FingerTrieSeq;
import swim.mqtt.MqttEncoder;
import swim.mqtt.MqttPacket;
import swim.mqtt.MqttQoS;
import swim.mqtt.MqttSubscription;
import swim.util.Murmur3;

public final class MqttSubscribe
extends MqttPacket<Object>
implements Debug {
    final int packetFlags;
    final int packetId;
    final FingerTrieSeq<MqttSubscription> subscriptions;
    private static int hashSeed;

    MqttSubscribe(int packetFlags, int packetId, FingerTrieSeq<MqttSubscription> subscriptions) {
        this.packetFlags = packetFlags;
        this.packetId = packetId;
        this.subscriptions = subscriptions;
    }

    @Override
    public int packetType() {
        return 8;
    }

    @Override
    public int packetFlags() {
        return this.packetFlags;
    }

    public MqttSubscribe packetFlags(int packetFlags) {
        return new MqttSubscribe(packetFlags, this.packetId, this.subscriptions);
    }

    public int packetId() {
        return this.packetId;
    }

    public MqttSubscribe packetId(int packetId) {
        return new MqttSubscribe(this.packetFlags, packetId, this.subscriptions);
    }

    public FingerTrieSeq<MqttSubscription> subscriptions() {
        return this.subscriptions;
    }

    public MqttSubscribe subscriptions(FingerTrieSeq<MqttSubscription> subscriptions) {
        return new MqttSubscribe(this.packetFlags, this.packetId, subscriptions);
    }

    public MqttSubscribe subscriptions(MqttSubscription ... subscriptions) {
        return new MqttSubscribe(this.packetFlags, this.packetId, (FingerTrieSeq<MqttSubscription>)FingerTrieSeq.of((Object[])subscriptions));
    }

    public MqttSubscribe subscription(MqttSubscription subscription) {
        return new MqttSubscribe(this.packetFlags, this.packetId, (FingerTrieSeq<MqttSubscription>)this.subscriptions.appended((Object)subscription));
    }

    public MqttSubscribe subscription(String topicName, MqttQoS qos) {
        return this.subscription(MqttSubscription.from(topicName, qos));
    }

    public MqttSubscribe subscription(String topicName) {
        return this.subscription(MqttSubscription.from(topicName));
    }

    @Override
    int bodySize(MqttEncoder mqtt) {
        int size = 2;
        int n = this.subscriptions.size();
        for (int i = 0; i < n; ++i) {
            size += ((MqttSubscription)this.subscriptions.get(i)).mqttSize(mqtt);
        }
        return size;
    }

    public Encoder<?, MqttSubscribe> mqttEncoder(MqttEncoder mqtt) {
        return mqtt.subscribeEncoder(this);
    }

    public Encoder<?, MqttSubscribe> encodeMqtt(OutputBuffer<?> output, MqttEncoder mqtt) {
        return mqtt.encodeSubscribe(this, output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MqttSubscribe) {
            MqttSubscribe that = (MqttSubscribe)other;
            return this.packetFlags == that.packetFlags && this.packetId == that.packetId && this.subscriptions.equals(that.subscriptions);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(MqttSubscribe.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.packetFlags), (int)this.packetId), (int)this.subscriptions.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("MqttSubscribe").write(46).write("from").write(40).debug((Object)this.packetId).write(41);
        if (this.packetFlags != 2) {
            output = output.write(46).write("packetFlags").write(40).debug((Object)this.packetFlags).write(41);
        }
        int n = this.subscriptions.size();
        for (int i = 0; i < n; ++i) {
            MqttSubscription subscription = (MqttSubscription)this.subscriptions.get(i);
            output = output.write(46).write("subscription").write(40).debug((Object)subscription.topicName);
            if ((subscription.flags & 3) != 0) {
                output = output.write(", ").debug((Object)subscription.qos());
            }
            output = output.write(41);
        }
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static MqttSubscribe from(int packetFlags, int packetId, FingerTrieSeq<MqttSubscription> subscriptions) {
        return new MqttSubscribe(packetFlags, packetId, subscriptions);
    }

    public static MqttSubscribe from(int packetId, FingerTrieSeq<MqttSubscription> subscriptions) {
        return new MqttSubscribe(2, packetId, subscriptions);
    }

    public static MqttSubscribe from(int packetId, MqttSubscription ... subscriptions) {
        return new MqttSubscribe(2, packetId, (FingerTrieSeq<MqttSubscription>)FingerTrieSeq.of((Object[])subscriptions));
    }

    public static MqttSubscribe from(int packetId) {
        return new MqttSubscribe(2, packetId, (FingerTrieSeq<MqttSubscription>)FingerTrieSeq.empty());
    }
}

