/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.core.model.v1;

import java.net.URI;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.switchyard.component.camel.common.QueryString;
import org.switchyard.component.camel.common.model.v1.V1BaseCamelBindingModel;
import org.switchyard.component.camel.core.model.CamelTimerBindingModel;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.Descriptor;

public class V1CamelTimerBindingModel
extends V1BaseCamelBindingModel
implements CamelTimerBindingModel {
    public static final String TIMER = "timer";
    private static final String NAME = "name";
    private static final String TIME = "time";
    private static final String PATTERN = "pattern";
    private static final String PERIOD = "period";
    private static final String DELAY = "delay";
    private static final String FIXED_RATE = "fixedRate";
    private static final String DAEMON = "daemon";
    private static DateFormat _dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public V1CamelTimerBindingModel(String namespace) {
        super(TIMER, namespace);
        this.setModelChildrenOrder(new String[]{NAME, TIME, PATTERN, PERIOD, DELAY, FIXED_RATE, DAEMON});
    }

    public V1CamelTimerBindingModel(Configuration config, Descriptor desc) {
        super(config, desc);
    }

    @Override
    public String getTimerName() {
        return this.getConfig(NAME);
    }

    @Override
    public V1CamelTimerBindingModel setTimerName(String name) {
        return (V1CamelTimerBindingModel)this.setConfig(NAME, name);
    }

    @Override
    public Date getTime() {
        return this.getDateConfig(TIME, _dateFormat);
    }

    @Override
    public V1CamelTimerBindingModel setTime(Date time) {
        return (V1CamelTimerBindingModel)this.setConfig(TIME, _dateFormat.format(time));
    }

    @Override
    public String getPattern() {
        return this.getConfig(PATTERN);
    }

    @Override
    public V1CamelTimerBindingModel setPattern(String pattern) {
        return (V1CamelTimerBindingModel)this.setConfig(PATTERN, pattern);
    }

    @Override
    public Long getPeriod() {
        return this.getLongConfig(PERIOD);
    }

    @Override
    public V1CamelTimerBindingModel setPeriod(Long period) {
        return (V1CamelTimerBindingModel)this.setConfig(PERIOD, period);
    }

    @Override
    public Long getDelay() {
        return this.getLongConfig(DELAY);
    }

    @Override
    public V1CamelTimerBindingModel setDelay(Long delay) {
        return (V1CamelTimerBindingModel)this.setConfig(DELAY, delay);
    }

    @Override
    public Boolean isFixedRate() {
        return this.getBooleanConfig(FIXED_RATE);
    }

    @Override
    public V1CamelTimerBindingModel setFixedRate(Boolean fixedRate) {
        return (V1CamelTimerBindingModel)this.setConfig(FIXED_RATE, fixedRate);
    }

    @Override
    public Boolean isDaemon() {
        return this.getBooleanConfig(DAEMON);
    }

    @Override
    public V1CamelTimerBindingModel setDaemon(Boolean daemon) {
        return (V1CamelTimerBindingModel)this.setConfig(DAEMON, daemon);
    }

    public URI getComponentURI() {
        String uriStr = "timer://" + this.getConfig(NAME);
        QueryString queryStr = new QueryString();
        this.traverseConfiguration(this.getModelConfiguration().getChildren(), queryStr, new String[]{NAME});
        return URI.create(uriStr.toString() + queryStr);
    }
}

