/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel;

import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.HandlerException;
import org.switchyard.ServiceReference;
import org.switchyard.component.camel.composer.CamelBindingData;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.component.common.composer.MessageComposer;
import org.switchyard.exception.SwitchYardException;

public class CamelResponseHandler
implements ExchangeHandler {
    private final org.apache.camel.Exchange _camelExchange;
    private final MessageComposer<CamelBindingData> _messageComposer;

    public CamelResponseHandler(org.apache.camel.Exchange camelExchange, ServiceReference reference, MessageComposer<CamelBindingData> messageComposer) {
        if (camelExchange == null) {
            throw new SwitchYardException("[camelExchange] argument must not be null");
        }
        if (reference == null) {
            throw new SwitchYardException("[reference] argument must not be null");
        }
        this._camelExchange = camelExchange;
        this._messageComposer = messageComposer;
    }

    public void handleMessage(Exchange switchYardExchange) throws HandlerException {
        try {
            Message camelMsg = this._camelExchange.getPattern().equals((Object)ExchangePattern.InOnly) ? this._camelExchange.getIn() : this._camelExchange.getOut();
            this._messageComposer.decompose(switchYardExchange, (BindingData)new CamelBindingData(camelMsg));
        }
        catch (Exception e) {
            throw new HandlerException((Throwable)e);
        }
    }

    public void handleFault(Exchange exchange) {
        Object content = exchange.getMessage().getContent();
        if (content instanceof Throwable) {
            this._camelExchange.setException((Throwable)content);
        }
    }
}

