/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.config.model;

import java.net.URI;
import java.net.URISyntaxException;
import org.switchyard.component.camel.config.model.ConfigURI;

public class DefaultConfigURI
implements ConfigURI {
    private String _uriString;
    private URI _uri;

    public DefaultConfigURI() {
    }

    public DefaultConfigURI(String uriString) {
        this._uriString = uriString;
    }

    @Override
    public URI getURI() {
        if (this._uri == null) {
            this._uri = this.parseStringAsURI(this._uriString);
        }
        return this._uri;
    }

    public void setURI(URI uri) {
        this._uri = uri;
    }

    public String getURIString() {
        return this._uriString;
    }

    public void setURIString(String uriString) {
        this._uriString = uriString;
    }

    @Override
    public String getScheme() {
        return this.getURI().getScheme();
    }

    public String toString() {
        return this._uriString;
    }

    protected URI parseStringAsURI(String uriString) {
        try {
            return new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("URI [" + uriString + "] was invalid. Please check the configuration.", e);
        }
    }
}

