/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.config.model.atom.v1;

import java.net.URI;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.switchyard.component.camel.config.model.CamelScheduledPollConsumer;
import org.switchyard.component.camel.config.model.QueryString;
import org.switchyard.component.camel.config.model.atom.CamelAtomBindingModel;
import org.switchyard.component.camel.config.model.v1.V1BaseCamelBindingModel;
import org.switchyard.component.camel.config.model.v1.V1CamelScheduledPollConsumer;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.Descriptor;
import org.switchyard.config.model.Model;

public class V1CamelAtomBindingModel
extends V1BaseCamelBindingModel
implements CamelAtomBindingModel {
    public static final String ATOM = "atom";
    private static final String FEED_URI = "feedURI";
    private static final String SPLIT_ENTRIES = "splitEntries";
    private static final String FILTER = "filter";
    private static final String LAST_UPDATE = "lastUpdate";
    private static final String THROTTLE_ENTRIES = "throttleEntries";
    private static final String FEED_HEADER = "feedHeader";
    private static final String SORT_ENTRIES = "sortEntries";
    public static final String CONSUME = "consume";
    private CamelScheduledPollConsumer _consume;
    private static DateFormat _dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public V1CamelAtomBindingModel() {
        super(ATOM);
        this.setModelChildrenOrder(new String[]{FEED_URI, SPLIT_ENTRIES, FILTER, LAST_UPDATE, THROTTLE_ENTRIES, FEED_HEADER, SORT_ENTRIES});
    }

    public V1CamelAtomBindingModel(Configuration config, Descriptor desc) {
        super(config, desc);
    }

    @Override
    public URI getFeedURI() {
        String uriStr = this.getConfig(FEED_URI);
        if (uriStr != null) {
            return URI.create(uriStr);
        }
        return null;
    }

    @Override
    public V1CamelAtomBindingModel setFeedURI(URI uri) {
        return (V1CamelAtomBindingModel)this.setConfig(FEED_URI, uri.toString());
    }

    @Override
    public Date getLastUpdate() {
        return this.getDateConfig(LAST_UPDATE, _dateFormat);
    }

    @Override
    public V1CamelAtomBindingModel setLastUpdate(Date date) {
        this.setConfig(LAST_UPDATE, _dateFormat.format(date));
        return this;
    }

    @Override
    public Boolean isFeedHeader() {
        return this.getBooleanConfig(FEED_HEADER);
    }

    @Override
    public V1CamelAtomBindingModel setFeedHeader(boolean feedHeader) {
        this.setConfig(FEED_HEADER, String.valueOf(feedHeader));
        return this;
    }

    @Override
    public Boolean isFiltered() {
        return this.getBooleanConfig(FILTER);
    }

    @Override
    public V1CamelAtomBindingModel setFiltered(boolean filtered) {
        this.setConfig(FILTER, String.valueOf(filtered));
        return this;
    }

    @Override
    public Boolean isSorted() {
        return this.getBooleanConfig(SORT_ENTRIES);
    }

    @Override
    public V1CamelAtomBindingModel setSorted(boolean sorted) {
        this.setConfig(SORT_ENTRIES, String.valueOf(sorted));
        return this;
    }

    @Override
    public Boolean isSplit() {
        return this.getBooleanConfig(SPLIT_ENTRIES);
    }

    @Override
    public V1CamelAtomBindingModel setSplit(boolean split) {
        this.setConfig(SPLIT_ENTRIES, String.valueOf(split));
        return this;
    }

    @Override
    public Boolean isThrottled() {
        return this.getBooleanConfig(THROTTLE_ENTRIES);
    }

    @Override
    public V1CamelAtomBindingModel setThrottled(boolean throttled) {
        this.setConfig(THROTTLE_ENTRIES, String.valueOf(throttled));
        return this;
    }

    @Override
    public CamelScheduledPollConsumer getConsumer() {
        if (this._consume == null) {
            Configuration config = this.getModelConfiguration().getFirstChild(CONSUME);
            this._consume = new V1CamelScheduledPollConsumer(config, this.getModelDescriptor());
        }
        return this._consume;
    }

    @Override
    public V1CamelAtomBindingModel setConsumer(CamelScheduledPollConsumer consumer) {
        Configuration config = this.getModelConfiguration().getFirstChild(CONSUME);
        if (config != null) {
            this.getModelConfiguration().removeChildren(CONSUME);
            this.getModelConfiguration().addChild(((V1CamelScheduledPollConsumer)consumer).getModelConfiguration());
        } else {
            this.setChildModel((Model)((V1CamelScheduledPollConsumer)consumer));
        }
        this._consume = consumer;
        return this;
    }

    @Override
    public URI getComponentURI() {
        Configuration modelConfiguration = this.getModelConfiguration();
        List children = modelConfiguration.getChildren();
        String baseUri = "atom://" + this.getFeedURI();
        QueryString queryStr = new QueryString();
        this.traverseConfiguration(children, queryStr, FEED_URI);
        return URI.create(baseUri + queryStr.toString());
    }
}

