/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.config.model.v1;

import java.net.URI;
import org.switchyard.common.net.SocketAddr;
import org.switchyard.component.camel.config.model.ConfigURI;
import org.switchyard.component.camel.config.model.ConfigURIFactory;
import org.switchyard.component.camel.config.model.v1.V1BaseCamelBindingModel;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.Descriptor;

public class V1CamelBindingModel
extends V1BaseCamelBindingModel {
    public static final String CAMEL = "camel";
    public static final String CONFIG_URI = "configURI";
    public static final String TRANSACTED = "transacted";
    public static final String TRANSACTED_REF = "transactedRef";
    private static final String SOCKET_ADDRESS = "socketAddr";
    private static final String CONTEXT_PATH = "contextPath";
    private ConfigURI _configURI;

    public V1CamelBindingModel() {
        super(CAMEL);
    }

    public V1CamelBindingModel(Configuration config, Descriptor desc) {
        super(config, desc);
        this.setModelChildrenOrder(new String[0]);
    }

    public ConfigURI getConfigURI() {
        if (this._configURI == null) {
            this._configURI = ConfigURIFactory.newConfigURI(this.getModelAttribute(CONFIG_URI), this.getSocketAddr(), this.getContextPath());
        }
        return this._configURI;
    }

    public V1CamelBindingModel setConfigURI(ConfigURI uri) {
        if (this._configURI == null) {
            this.setModelAttribute(CONFIG_URI, uri.toString());
            this._configURI = uri;
        }
        return this;
    }

    public V1CamelBindingModel setConfigURI(URI uri) {
        if (this._configURI == null) {
            this.setModelAttribute(CONFIG_URI, uri.toString());
            this._configURI = ConfigURIFactory.newConfigURI(uri.toString(), this.getSocketAddr(), this.getContextPath());
        }
        return this;
    }

    private SocketAddr getSocketAddr() {
        Configuration hostConfig = this.getEnvironment().getFirstChild(SOCKET_ADDRESS);
        SocketAddr socketAddr = null;
        socketAddr = hostConfig != null && hostConfig.getValue() != null ? new SocketAddr(hostConfig.getValue()) : new SocketAddr();
        return socketAddr;
    }

    private String getContextPath() {
        Configuration hostConfig = this.getEnvironment().getFirstChild(CONTEXT_PATH);
        String contextPath = "";
        if (hostConfig != null && hostConfig.getValue() != null) {
            contextPath = "/" + hostConfig.getValue();
        }
        return contextPath;
    }

    @Override
    public URI getComponentURI() {
        return this.getConfigURI().getURI();
    }
}

