/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.processor;

import java.util.Map;
import org.switchyard.Exchange;
import org.switchyard.component.camel.composer.CamelBindingData;
import org.switchyard.component.camel.processor.DefaultProcessor;
import org.switchyard.component.common.composer.MessageComposer;
import org.switchyard.component.common.rest.RsMethod;
import org.switchyard.component.common.rest.RsMethodUtil;

public class CxfRsHttpDynamicProcessor
extends DefaultProcessor {
    private Map<String, RsMethod> _resourcePaths;

    public CxfRsHttpDynamicProcessor(MessageComposer<CamelBindingData> composer, Exchange exchange, String uri) {
        super(composer, exchange);
        String resourceClasses = uri.split("resourceClasses=")[1].split("&")[0];
        this._resourcePaths = RsMethodUtil.parseResources((String)resourceClasses);
    }

    @Override
    public void process(org.apache.camel.Exchange camelExchange) throws Exception {
        RsMethod restMethod = this._resourcePaths.get(this.getExchange().getContract().getProviderOperation().toString());
        if (restMethod == null) {
            throw new RuntimeException("Could not map " + this.getExchange().getContract().getProviderOperation().getName() + " to any REST method.");
        }
        camelExchange.getIn().setHeader("CamelCxfRsUsingHttpAPI", (Object)Boolean.TRUE);
        camelExchange.getIn().setHeader("CamelCxfRsResponseClass", (Object)restMethod.getResponseType());
        camelExchange.getIn().setHeader("CamelHttpMethod", (Object)restMethod.getMethod());
        String path = RsMethodUtil.getPath((RsMethod)restMethod, (Exchange)this.getExchange());
        camelExchange.getIn().setHeader("CamelHttpPath", (Object)path);
        super.process(camelExchange);
    }
}

